/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.psi.PsiFile;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;

public class MavenAttachSourcesProvider
implements AttachSourcesProvider {
    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> orderEntries, final PsiFile psiFile) {
        Collection<MavenProject> projects = MavenAttachSourcesProvider.getMavenProjects(psiFile);
        if (projects.isEmpty()) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                MavenAttachSourcesProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (MavenAttachSourcesProvider.findArtifacts(projects, orderEntries).isEmpty()) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                MavenAttachSourcesProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        Set<AttachSourcesProvider.AttachSourcesAction> set = Collections.singleton(new AttachSourcesProvider.AttachSourcesAction(){

            public String getName() {
                return ProjectBundle.message("maven.action.download.sources", new Object[0]);
            }

            public String getBusyText() {
                return ProjectBundle.message("maven.action.download.sources.busy.text", new Object[0]);
            }

            public ActionCallback perform(List<LibraryOrderEntry> orderEntries) {
                Collection mavenProjects = MavenAttachSourcesProvider.getMavenProjects(psiFile);
                if (mavenProjects.isEmpty()) {
                    return ActionCallback.REJECTED;
                }
                MavenProjectsManager manager = MavenProjectsManager.getInstance(psiFile.getProject());
                Collection artifacts = MavenAttachSourcesProvider.findArtifacts(mavenProjects, orderEntries);
                if (artifacts.isEmpty()) {
                    return ActionCallback.REJECTED;
                }
                AsyncResult result = new AsyncResult();
                manager.scheduleArtifactsDownloading(mavenProjects, artifacts, true, false, (AsyncResult<MavenArtifactDownloader.DownloadResult>)result);
                ActionCallback resultWrapper = new ActionCallback();
                result.doWhenDone(downloadResult -> {
                    if (!downloadResult.unresolvedSources.isEmpty()) {
                        StringBuilder message = new StringBuilder();
                        message.append("<html>Sources not found for:");
                        int count = 0;
                        for (MavenId each : downloadResult.unresolvedSources) {
                            if (count++ > 5) {
                                message.append("<br>and more...");
                                break;
                            }
                            message.append("<br>").append(each.getDisplayString());
                        }
                        message.append("</html>");
                        Notifications.Bus.notify((Notification)new Notification("Maven", "Cannot download sources", message.toString(), NotificationType.WARNING), (Project)psiFile.getProject());
                    }
                    if (downloadResult.resolvedSources.isEmpty()) {
                        resultWrapper.setRejected();
                    } else {
                        resultWrapper.setDone();
                    }
                });
                return resultWrapper;
            }
        });
        if (set == null) {
            MavenAttachSourcesProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static Collection<MavenArtifact> findArtifacts(Collection<MavenProject> mavenProjects, List<LibraryOrderEntry> orderEntries) {
        THashSet artifacts = new THashSet();
        for (MavenProject each : mavenProjects) {
            for (LibraryOrderEntry entry : orderEntries) {
                MavenArtifact artifact = MavenRootModelAdapter.findArtifact(each, entry.getLibrary());
                if (artifact == null || "system".equals(artifact.getScope())) continue;
                artifacts.add(artifact);
            }
        }
        return artifacts;
    }

    private static Collection<MavenProject> getMavenProjects(PsiFile psiFile) {
        Project project = psiFile.getProject();
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (OrderEntry each : ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(psiFile.getVirtualFile())) {
            MavenProject mavenProject = MavenProjectsManager.getInstance(project).findProject(each.getOwnerModule());
            if (mavenProject == null) continue;
            result.add(mavenProject);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenAttachSourcesProvider", "getActions"));
    }
}

