/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.wizards.MavenProjectBuilder;

public class SelectProfilesStep
extends ProjectImportWizardStep {
    private JPanel panel;
    private MultiStateElementsChooser<String, MavenProfileKind> profileChooser;
    private MavenProfileKindMarkStateDescriptor myMarkStateDescriptor;

    public SelectProfilesStep(WizardContext context) {
        super(context);
        this.$$$setupUI$$$();
    }

    public boolean isStepVisible() {
        if (!super.isStepVisible()) {
            return false;
        }
        MavenProjectBuilder importBuilder = this.getBuilder();
        if (importBuilder != null) {
            return !importBuilder.getProfiles().isEmpty();
        }
        return false;
    }

    protected MavenProjectBuilder getBuilder() {
        return (MavenProjectBuilder)super.getBuilder();
    }

    public void createUIComponents() {
        this.myMarkStateDescriptor = new MavenProfileKindMarkStateDescriptor();
        this.profileChooser = new MultiStateElementsChooser(true, (MultiStateElementsChooser.MarkStateDescriptor)this.myMarkStateDescriptor);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void updateStep() {
        List<String> allProfiles = this.getBuilder().getProfiles();
        List<String> activatedProfiles = this.getBuilder().getActivatedProfiles();
        MavenExplicitProfiles selectedProfiles = this.getBuilder().getSelectedProfiles();
        ArrayList enabledProfiles = new ArrayList(selectedProfiles.getEnabledProfiles());
        ArrayList disabledProfiles = new ArrayList(selectedProfiles.getDisabledProfiles());
        enabledProfiles.retainAll(allProfiles);
        disabledProfiles.retainAll(allProfiles);
        this.myMarkStateDescriptor.setActivatedProfiles(activatedProfiles);
        this.profileChooser.setElements(allProfiles, null);
        this.profileChooser.markElements(enabledProfiles, (Object)MavenProfileKind.EXPLICIT);
        this.profileChooser.markElements(disabledProfiles, (Object)MavenProfileKind.NONE);
    }

    public boolean validate() throws ConfigurationException {
        Collection<String> activatedProfiles = this.myMarkStateDescriptor.getActivatedProfiles();
        MavenExplicitProfiles newSelectedProfiles = MavenExplicitProfiles.NONE.clone();
        for (Map.Entry entry : this.profileChooser.getElementMarkStates().entrySet()) {
            String profile = (String)entry.getKey();
            MavenProfileKind profileKind = (MavenProfileKind)entry.getValue();
            switch (profileKind) {
                case NONE: {
                    if (!activatedProfiles.contains(profile)) break;
                    newSelectedProfiles.getDisabledProfiles().add(profile);
                    break;
                }
                case EXPLICIT: {
                    newSelectedProfiles.getEnabledProfiles().add(profile);
                    break;
                }
            }
        }
        return this.getBuilder().setSelectedProfiles(newSelectedProfiles);
    }

    public void updateDataModel() {
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.import.maven.page2";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(8, 8, 8, 8), -1, -1, false, false));
        MultiStateElementsChooser<String, MavenProfileKind> multiStateElementsChooser = this.profileChooser;
        jPanel.add((Component)multiStateElementsChooser, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel.getFont());
        if (font != null) {
            jLabel.setFont(font);
        }
        jLabel.setText("Select profiles:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private static class CheckboxTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckboxTableCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorder(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            MavenProfileKind state = (MavenProfileKind)value;
            this.setSelected(state != MavenProfileKind.NONE);
            this.setEnabled(state != MavenProfileKind.IMPLICIT);
            return this;
        }
    }

    private static class MavenProfileKindMarkStateDescriptor
    implements MultiStateElementsChooser.MarkStateDescriptor<String, MavenProfileKind> {
        private Collection<String> myActivatedProfiles = Collections.emptySet();

        private MavenProfileKindMarkStateDescriptor() {
        }

        public Collection<String> getActivatedProfiles() {
            return this.myActivatedProfiles;
        }

        public void setActivatedProfiles(Collection<String> activatedProfiles) {
            this.myActivatedProfiles = new THashSet(activatedProfiles);
        }

        @NotNull
        public MavenProfileKind getDefaultState(@NotNull String element) {
            if (element == null) {
                MavenProfileKindMarkStateDescriptor.$$$reportNull$$$0(0);
            }
            MavenProfileKind mavenProfileKind = this.myActivatedProfiles.contains(element) ? MavenProfileKind.IMPLICIT : MavenProfileKind.NONE;
            if (mavenProfileKind == null) {
                MavenProfileKindMarkStateDescriptor.$$$reportNull$$$0(1);
            }
            return mavenProfileKind;
        }

        @NotNull
        public MavenProfileKind getNextState(@NotNull String element, @NotNull MavenProfileKind state) {
            MavenProfileKind nextState;
            if (element == null) {
                MavenProfileKindMarkStateDescriptor.$$$reportNull$$$0(2);
            }
            if (state == null) {
                MavenProfileKindMarkStateDescriptor.$$$reportNull$$$0(3);
            }
            switch (state) {
                case NONE: {
                    nextState = MavenProfileKind.EXPLICIT;
                    break;
                }
                case EXPLICIT: {
                    nextState = this.getDefaultState(element);
                    break;
                }
                default: {
                    nextState = MavenProfileKind.NONE;
                }
            }
            MavenProfileKind mavenProfileKind = nextState;
            if (mavenProfileKind == null) {
                MavenProfileKindMarkStateDescriptor.$$$reportNull$$$0(4);
            }
            return mavenProfileKind;
        }

        @Nullable
        public MavenProfileKind getNextState(@NotNull Map<String, MavenProfileKind> elementsWithStates) {
            if (elementsWithStates == null) {
                MavenProfileKindMarkStateDescriptor.$$$reportNull$$$0(5);
            }
            MavenProfileKind nextState = null;
            for (Map.Entry<String, MavenProfileKind> entry : elementsWithStates.entrySet()) {
                MavenProfileKind nextElementState = this.getNextState(entry.getKey(), entry.getValue());
                if (nextState == null) {
                    nextState = nextElementState;
                    continue;
                }
                if (nextState.equals((Object)nextElementState)) continue;
                nextState = null;
                break;
            }
            return nextState;
        }

        public boolean isMarked(@NotNull MavenProfileKind state) {
            if (state == null) {
                MavenProfileKindMarkStateDescriptor.$$$reportNull$$$0(6);
            }
            return state != MavenProfileKind.NONE;
        }

        @Nullable
        public MavenProfileKind getMarkState(@Nullable Object value) {
            return value instanceof MavenProfileKind ? (MavenProfileKind)value : null;
        }

        @Nullable
        public TableCellRenderer getMarkRenderer() {
            return new CheckboxTableCellRenderer();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/wizards/SelectProfilesStep$MavenProfileKindMarkStateDescriptor";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementsWithStates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/wizards/SelectProfilesStep$MavenProfileKindMarkStateDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultState";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultState";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getNextState";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isMarked";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

