/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.plugins.gradle.tooling.builder.ModuleExtendedModelBuilderImpl;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaContentRootImpl;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaSourceDirectoryImpl;

class IdeaModuleDirectorySet {
    private final Set<String> sourceDirectories = new HashSet<String>();
    private final Set<String> testDirectories = new HashSet<String>();
    private final Set<String> resourceDirectories = new HashSet<String>();
    private final Set<String> testResourceDirectories = new HashSet<String>();
    private final Set<String> generatedSourceDirectories = new HashSet<String>();
    private final Set<File> excludedDirectories = new HashSet<File>();

    IdeaModuleDirectorySet() {
    }

    public Set<String> getSourceDirectories() {
        return this.sourceDirectories;
    }

    public Set<String> getTestDirectories() {
        return this.testDirectories;
    }

    public Set<String> getResourceDirectories() {
        return this.resourceDirectories;
    }

    public Set<String> getTestResourceDirectories() {
        return this.testResourceDirectories;
    }

    public Set<String> getGeneratedSourceDirectories() {
        return this.generatedSourceDirectories;
    }

    public Set<File> getExcludedDirectories() {
        return this.excludedDirectories;
    }

    public void mergeFrom(IdeaModuleDirectorySet other) {
        if (ModuleExtendedModelBuilderImpl.is50OrBetter) {
            if (other.getSourceDirectories().isEmpty()) {
                this.sourceDirectories.clear();
            }
            if (other.getResourceDirectories().isEmpty()) {
                this.resourceDirectories.clear();
            }
            if (other.getTestDirectories().isEmpty()) {
                this.testDirectories.clear();
            }
            if (other.getTestResourceDirectories().isEmpty()) {
                this.testResourceDirectories.clear();
            }
        } else {
            if (other.getSourceDirectories().isEmpty()) {
                this.sourceDirectories.clear();
                this.resourceDirectories.clear();
            }
            if (other.getTestDirectories().isEmpty()) {
                this.testDirectories.clear();
                this.testResourceDirectories.clear();
            }
        }
        HashSet<String> otherSourceDirectories = new HashSet<String>(other.getSourceDirectories());
        HashSet<String> otherTestDirectories = new HashSet<String>(other.getTestDirectories());
        otherSourceDirectories.removeAll(this.resourceDirectories);
        this.sourceDirectories.removeAll(otherTestDirectories);
        this.sourceDirectories.addAll(otherSourceDirectories);
        otherTestDirectories.removeAll(this.testResourceDirectories);
        this.testDirectories.addAll(otherTestDirectories);
        this.resourceDirectories.removeAll(this.sourceDirectories);
        this.testDirectories.removeAll(this.sourceDirectories);
        this.testResourceDirectories.removeAll(this.testDirectories);
        this.generatedSourceDirectories.addAll(other.getGeneratedSourceDirectories());
        this.excludedDirectories.addAll(other.getExcludedDirectories());
    }

    public void fill(IdeaContentRootImpl contentRoot) {
        for (String javaDir : this.sourceDirectories) {
            contentRoot.addSourceDirectory(new IdeaSourceDirectoryImpl(new File(javaDir), this.generatedSourceDirectories.contains(javaDir)));
        }
        for (String testDir : this.testDirectories) {
            contentRoot.addTestDirectory(new IdeaSourceDirectoryImpl(new File(testDir), this.generatedSourceDirectories.contains(testDir)));
        }
        for (String resourceDir : this.resourceDirectories) {
            contentRoot.addResourceDirectory(new IdeaSourceDirectoryImpl(new File(resourceDir)));
        }
        for (String testResourceDir : this.testResourceDirectories) {
            contentRoot.addTestResourceDirectory(new IdeaSourceDirectoryImpl(new File(testResourceDir)));
        }
        for (File excludeDir : this.excludedDirectories) {
            contentRoot.addExcludeDirectory(excludeDir);
        }
    }
}

