/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.commons.compress.compressors.lzma;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.impldep.org.apache.commons.compress.MemoryLimitException;
import org.gradle.internal.impldep.org.apache.commons.compress.compressors.CompressorInputStream;
import org.tukaani.xz.LZMAInputStream;

public class LZMACompressorInputStream
extends CompressorInputStream {
    private final InputStream in;

    public LZMACompressorInputStream(InputStream inputStream) throws IOException {
        this.in = new LZMAInputStream(inputStream, -1);
    }

    public LZMACompressorInputStream(InputStream inputStream, int memoryLimitInKb) throws IOException {
        try {
            this.in = new LZMAInputStream(inputStream, memoryLimitInKb);
        }
        catch (org.tukaani.xz.MemoryLimitException e) {
            throw new MemoryLimitException(e.getMemoryNeeded(), e.getMemoryLimit(), (Exception)((Object)e));
        }
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        this.count(ret == -1 ? 0 : 1);
        return ret;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int ret = this.in.read(buf, off, len);
        this.count(ret);
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static boolean matches(byte[] signature, int length) {
        if (signature == null || length < 3) {
            return false;
        }
        if (signature[0] != 93) {
            return false;
        }
        if (signature[1] != 0) {
            return false;
        }
        return signature[2] == 0;
    }
}

