/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.wagon;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.gradle.internal.impldep.org.apache.maven.wagon.ResourceDoesNotExistException;
import org.gradle.internal.impldep.org.apache.maven.wagon.TransferFailedException;
import org.gradle.internal.impldep.org.apache.maven.wagon.Wagon;
import org.gradle.internal.impldep.org.apache.maven.wagon.authorization.AuthorizationException;
import org.gradle.internal.impldep.org.codehaus.plexus.util.FileUtils;

public final class WagonUtils {
    private WagonUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String resource, Wagon wagon) throws IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File file = null;
        try {
            file = File.createTempFile("wagon", "tmp");
            wagon.get(resource, file);
            String string = FileUtils.fileRead(file);
            return string;
        }
        finally {
            boolean deleted;
            if (file != null && !(deleted = file.delete())) {
                file.deleteOnExit();
            }
        }
    }

    public static void putDirectory(File dir2, Wagon wagon, boolean includeBasdir) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        LinkedList<String> queue = new LinkedList<String>();
        if (includeBasdir) {
            queue.add(dir2.getName());
        } else {
            queue.add("");
        }
        while (!queue.isEmpty()) {
            String path = (String)queue.removeFirst();
            File currentDir = new File(dir2, path);
            File[] files = currentDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String resource = path.length() > 0 ? path + "/" + file.getName() : file.getName();
                if (file.isDirectory()) {
                    queue.add(resource);
                    continue;
                }
                wagon.put(file, resource);
            }
        }
    }
}

