/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import org.gradle.internal.impldep.org.eclipse.jgit.api.Git;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.JGitInternalException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.RepositoryBuilder;
import org.gradle.internal.impldep.org.eclipse.jgit.util.SystemReader;

public class InitCommand
implements Callable<Git> {
    private File directory;
    private File gitDir;
    private boolean bare;

    @Override
    public Git call() throws GitAPIException {
        try {
            String dStr;
            RepositoryBuilder builder = new RepositoryBuilder();
            if (this.bare) {
                builder.setBare();
            }
            builder.readEnvironment();
            if (this.gitDir != null) {
                builder.setGitDir(this.gitDir);
            } else {
                this.gitDir = builder.getGitDir();
            }
            if (this.directory != null) {
                if (this.bare) {
                    builder.setGitDir(this.directory);
                } else {
                    builder.setWorkTree(this.directory);
                    if (this.gitDir == null) {
                        builder.setGitDir(new File(this.directory, ".git"));
                    }
                }
            } else if (builder.getGitDir() == null) {
                dStr = SystemReader.getInstance().getProperty("user.dir");
                if (dStr == null) {
                    dStr = ".";
                }
                File d = new File(dStr);
                if (!this.bare) {
                    d = new File(d, ".git");
                }
                builder.setGitDir(d);
            } else if (!this.bare) {
                dStr = SystemReader.getInstance().getProperty("user.dir");
                if (dStr == null) {
                    dStr = ".";
                }
                builder.setWorkTree(new File(dStr));
            }
            Object repository = builder.build();
            if (!((Repository)repository).getObjectDatabase().exists()) {
                ((Repository)repository).create(this.bare);
            }
            return new Git((Repository)repository);
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public InitCommand setDirectory(File directory) throws IllegalStateException {
        InitCommand.validateDirs(directory, this.gitDir, this.bare);
        this.directory = directory;
        return this;
    }

    public InitCommand setGitDir(File gitDir) throws IllegalStateException {
        InitCommand.validateDirs(this.directory, gitDir, this.bare);
        this.gitDir = gitDir;
        return this;
    }

    private static void validateDirs(File directory, File gitDir, boolean bare) throws IllegalStateException {
        if (directory != null) {
            if (bare) {
                if (gitDir != null && !gitDir.equals(directory)) {
                    throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedBareRepoDifferentDirs, gitDir, directory));
                }
            } else if (gitDir != null && gitDir.equals(directory)) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedNonBareRepoSameDirs, gitDir, directory));
            }
        }
    }

    public InitCommand setBare(boolean bare) {
        InitCommand.validateDirs(this.directory, this.gitDir, bare);
        this.bare = bare;
        return this;
    }
}

