/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file.PackIndex;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.pack.PackExt;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftree.RefTreeNames;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.AnyObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.NullProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectIdSet;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectReader;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.RefDatabase;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.storage.pack.PackConfig;
import org.gradle.internal.impldep.org.eclipse.jgit.storage.pack.PackStatistics;
import org.gradle.internal.impldep.org.eclipse.jgit.util.io.CountingOutputStream;

public class DfsGarbageCollector {
    private final DfsRepository repo;
    private final RefDatabase refdb;
    private final DfsObjDatabase objdb;
    private final List<DfsPackDescription> newPackDesc;
    private final List<PackStatistics> newPackStats;
    private final List<ObjectIdSet> newPackObj;
    private DfsReader ctx;
    private PackConfig packConfig;
    private long coalesceGarbageLimit = 0x3200000L;
    private long garbageTtlMillis = TimeUnit.DAYS.toMillis(1L);
    private long startTimeMillis;
    private List<DfsPackFile> packsBefore;
    private List<DfsPackFile> expiredGarbagePacks;
    private Set<ObjectId> allHeads;
    private Set<ObjectId> nonHeads;
    private Set<ObjectId> txnHeads;
    private Set<ObjectId> tagTargets;

    public DfsGarbageCollector(DfsRepository repository) {
        this.repo = repository;
        this.refdb = this.repo.getRefDatabase();
        this.objdb = this.repo.getObjectDatabase();
        this.newPackDesc = new ArrayList<DfsPackDescription>(4);
        this.newPackStats = new ArrayList<PackStatistics>(4);
        this.newPackObj = new ArrayList<ObjectIdSet>(4);
        this.packConfig = new PackConfig(this.repo);
        this.packConfig.setIndexVersion(2);
    }

    public PackConfig getPackConfig() {
        return this.packConfig;
    }

    public DfsGarbageCollector setPackConfig(PackConfig newConfig) {
        this.packConfig = newConfig;
        return this;
    }

    public long getCoalesceGarbageLimit() {
        return this.coalesceGarbageLimit;
    }

    public DfsGarbageCollector setCoalesceGarbageLimit(long limit) {
        this.coalesceGarbageLimit = limit;
        return this;
    }

    public long getGarbageTtlMillis() {
        return this.garbageTtlMillis;
    }

    public DfsGarbageCollector setGarbageTtl(long ttl, TimeUnit unit) {
        this.garbageTtlMillis = unit.toMillis(ttl);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pack(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        if (this.packConfig.getIndexVersion() != 2) {
            throw new IllegalStateException(JGitText.get().supportOnlyPackIndexVersion2);
        }
        if (this.garbageTtlMillis > 0L) {
            this.coalesceGarbageLimit = 0L;
        }
        this.startTimeMillis = System.currentTimeMillis();
        this.ctx = (DfsReader)this.objdb.newReader();
        try {
            this.refdb.refresh();
            this.objdb.clearCache();
            Collection<Ref> refsBefore = this.getAllRefs();
            this.readPacksBefore();
            if (this.packsBefore.isEmpty()) {
                if (!this.expiredGarbagePacks.isEmpty()) {
                    this.objdb.commitPack(DfsGarbageCollector.noPacks(), this.toPrune());
                }
                boolean bl = true;
                return bl;
            }
            this.allHeads = new HashSet<ObjectId>();
            this.nonHeads = new HashSet<ObjectId>();
            this.txnHeads = new HashSet<ObjectId>();
            this.tagTargets = new HashSet<ObjectId>();
            for (Ref ref : refsBefore) {
                if (ref.isSymbolic() || ref.getObjectId() == null) continue;
                if (DfsGarbageCollector.isHead(ref)) {
                    this.allHeads.add(ref.getObjectId());
                } else if (RefTreeNames.isRefTree(this.refdb, ref.getName())) {
                    this.txnHeads.add(ref.getObjectId());
                } else {
                    this.nonHeads.add(ref.getObjectId());
                }
                if (ref.getPeeledObjectId() == null) continue;
                this.tagTargets.add(ref.getPeeledObjectId());
            }
            this.tagTargets.addAll(this.allHeads);
            boolean rollback = true;
            try {
                this.packHeads(pm);
                this.packRest(pm);
                this.packRefTreeGraph(pm);
                this.packGarbage(pm);
                this.objdb.commitPack(this.newPackDesc, this.toPrune());
                rollback = false;
                boolean bl = true;
                if (rollback) {
                    this.objdb.rollbackPack(this.newPackDesc);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (rollback) {
                    this.objdb.rollbackPack(this.newPackDesc);
                }
                throw throwable;
            }
        }
        finally {
            this.ctx.close();
        }
    }

    private Collection<Ref> getAllRefs() throws IOException {
        Collection<Ref> refs = this.refdb.getRefs("").values();
        List<Ref> addl = this.refdb.getAdditionalRefs();
        if (!addl.isEmpty()) {
            ArrayList<Ref> all = new ArrayList<Ref>(refs.size() + addl.size());
            all.addAll(refs);
            for (Ref r : addl) {
                if (!r.getName().startsWith("refs/")) continue;
                all.add(r);
            }
            return all;
        }
        return refs;
    }

    private void readPacksBefore() throws IOException {
        DfsPackFile[] packs = this.objdb.getPacks();
        this.packsBefore = new ArrayList<DfsPackFile>(packs.length);
        this.expiredGarbagePacks = new ArrayList<DfsPackFile>(packs.length);
        long mostRecentGC = DfsGarbageCollector.mostRecentGC(packs);
        long now = System.currentTimeMillis();
        for (DfsPackFile p : packs) {
            DfsPackDescription d = p.getPackDescription();
            if (d.getPackSource() != DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE) {
                this.packsBefore.add(p);
                continue;
            }
            if (this.packIsExpiredGarbage(d, mostRecentGC, now)) {
                this.expiredGarbagePacks.add(p);
                continue;
            }
            if (d.getFileSize(PackExt.PACK) >= this.coalesceGarbageLimit) continue;
            this.packsBefore.add(p);
        }
    }

    private static long mostRecentGC(DfsPackFile[] packs) {
        long r = 0L;
        for (DfsPackFile p : packs) {
            DfsPackDescription d = p.getPackDescription();
            if (d.getPackSource() != DfsObjDatabase.PackSource.GC && d.getPackSource() != DfsObjDatabase.PackSource.GC_REST) continue;
            r = Math.max(r, d.getLastModified());
        }
        return r;
    }

    private boolean packIsExpiredGarbage(DfsPackDescription d, long mostRecentGC, long now) {
        return d.getPackSource() == DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE && d.getLastModified() < mostRecentGC && this.garbageTtlMillis > 0L && now - d.getLastModified() >= this.garbageTtlMillis;
    }

    public List<DfsPackDescription> getSourcePacks() {
        return this.toPrune();
    }

    public List<DfsPackDescription> getNewPacks() {
        return this.newPackDesc;
    }

    public List<PackStatistics> getNewPackStatistics() {
        return this.newPackStats;
    }

    private List<DfsPackDescription> toPrune() {
        int cnt = this.packsBefore.size();
        ArrayList<DfsPackDescription> all = new ArrayList<DfsPackDescription>(cnt);
        for (DfsPackFile pack : this.packsBefore) {
            all.add(pack.getPackDescription());
        }
        for (DfsPackFile pack : this.expiredGarbagePacks) {
            all.add(pack.getPackDescription());
        }
        return all;
    }

    private void packHeads(ProgressMonitor pm) throws IOException {
        if (this.allHeads.isEmpty()) {
            return;
        }
        try (PackWriter pw = this.newPackWriter();){
            pw.setTagTargets(this.tagTargets);
            pw.preparePack(pm, this.allHeads, PackWriter.NONE);
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.GC, pw, pm);
            }
        }
    }

    private void packRest(ProgressMonitor pm) throws IOException {
        if (this.nonHeads.isEmpty()) {
            return;
        }
        try (PackWriter pw = this.newPackWriter();){
            for (ObjectIdSet packedObjs : this.newPackObj) {
                pw.excludeObjects(packedObjs);
            }
            pw.preparePack(pm, this.nonHeads, this.allHeads);
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.GC_REST, pw, pm);
            }
        }
    }

    private void packRefTreeGraph(ProgressMonitor pm) throws IOException {
        if (this.txnHeads.isEmpty()) {
            return;
        }
        try (PackWriter pw = this.newPackWriter();){
            for (ObjectIdSet packedObjs : this.newPackObj) {
                pw.excludeObjects(packedObjs);
            }
            pw.preparePack(pm, this.txnHeads, PackWriter.NONE);
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.GC_TXN, pw, pm);
            }
        }
    }

    private void packGarbage(ProgressMonitor pm) throws IOException {
        PackConfig cfg = new PackConfig(this.packConfig);
        cfg.setReuseDeltas(true);
        cfg.setReuseObjects(true);
        cfg.setDeltaCompress(false);
        cfg.setBuildBitmaps(false);
        try (PackWriter pw = new PackWriter(cfg, (ObjectReader)this.ctx);
             RevWalk pool = new RevWalk(this.ctx);){
            pw.setDeltaBaseAsOffset(true);
            pw.setReuseDeltaCommits(true);
            pm.beginTask(JGitText.get().findingGarbage, this.objectsBefore());
            for (DfsPackFile oldPack : this.packsBefore) {
                PackIndex oldIdx = oldPack.getPackIndex(this.ctx);
                for (PackIndex.MutableEntry ent : oldIdx) {
                    pm.update(1);
                    ObjectId id = ent.toObjectId();
                    if (pool.lookupOrNull(id) != null || this.anyPackHas(id)) continue;
                    int type = oldPack.getObjectType(this.ctx, ent.getOffset());
                    pw.addObject(pool.lookupAny(id, type));
                }
            }
            pm.endTask();
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE, pw, pm);
            }
        }
    }

    private boolean anyPackHas(AnyObjectId id) {
        for (ObjectIdSet packedObjs : this.newPackObj) {
            if (!packedObjs.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static boolean isHead(Ref ref) {
        return ref.getName().startsWith("refs/heads/");
    }

    private int objectsBefore() {
        int cnt = 0;
        for (DfsPackFile p : this.packsBefore) {
            cnt = (int)((long)cnt + p.getPackDescription().getObjectCount());
        }
        return cnt;
    }

    private PackWriter newPackWriter() {
        PackWriter pw = new PackWriter(this.packConfig, (ObjectReader)this.ctx);
        pw.setDeltaBaseAsOffset(true);
        pw.setReuseDeltaCommits(false);
        return pw;
    }

    private DfsPackDescription writePack(DfsObjDatabase.PackSource source, PackWriter pw, ProgressMonitor pm) throws IOException {
        DfsPackDescription pack = this.repo.getObjectDatabase().newPack(source);
        this.newPackDesc.add(pack);
        try (DfsOutputStream out = this.objdb.writeFile(pack, PackExt.PACK);){
            pw.writePack(pm, pm, out);
            pack.addFileExt(PackExt.PACK);
        }
        var6_6 = null;
        try (CountingOutputStream cnt = new CountingOutputStream(this.objdb.writeFile(pack, PackExt.INDEX));){
            pw.writeIndex(cnt);
            pack.addFileExt(PackExt.INDEX);
            pack.setFileSize(PackExt.INDEX, cnt.getCount());
            pack.setIndexVersion(pw.getIndexVersion());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        if (pw.prepareBitmapIndex(pm)) {
            cnt = new CountingOutputStream(this.objdb.writeFile(pack, PackExt.BITMAP_INDEX));
            var6_6 = null;
            try {
                pw.writeBitmapIndex(cnt);
                pack.addFileExt(PackExt.BITMAP_INDEX);
                pack.setFileSize(PackExt.BITMAP_INDEX, cnt.getCount());
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (cnt != null) {
                    if (var6_6 != null) {
                        try {
                            cnt.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        cnt.close();
                    }
                }
            }
        }
        PackStatistics stats = pw.getStatistics();
        pack.setPackStats(stats);
        pack.setLastModified(this.startTimeMillis);
        this.newPackStats.add(stats);
        this.newPackObj.add(pw.getObjectSet());
        DfsBlockCache.getInstance().getOrCreate(pack, null);
        return pack;
    }

    private static List<DfsPackDescription> noPacks() {
        return Collections.emptyList();
    }
}

