/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.inspection;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateFileResourceQuickFix;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.AndroidUtilKt;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/android/inspection/KotlinAndroidResourceQuickFixProvider;", "Lcom/intellij/codeInsight/quickfix/UnresolvedReferenceQuickFixProvider;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "()V", "getReferenceClass", "Ljava/lang/Class;", "registerFixes", "", "ref", "registrar", "Lcom/intellij/codeInsight/daemon/QuickFixActionRegistrar;", "idea-android"})
public final class KotlinAndroidResourceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<KtSimpleNameReference> {
    public void registerFixes(@NotNull KtSimpleNameReference ref, @NotNull QuickFixActionRegistrar registrar) {
        ResourceFolderType resourceFolderType;
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        Intrinsics.checkParameterIsNotNull((Object)registrar, (String)"registrar");
        KtSimpleNameExpression expression = (KtSimpleNameExpression)ref.getExpression();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)expression));
        if (module == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ModuleUtil.findModuleFor\u2026ent(expression) ?: return");
        Module contextModule = module;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)contextModule);
        if (androidFacet == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)androidFacet, (String)"AndroidFacet.getInstance(contextModule) ?: return");
        AndroidFacet facet = androidFacet;
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)manifest, (String)"facet.manifest ?: return");
        Manifest manifest2 = manifest;
        GenericAttributeValue genericAttributeValue = manifest2.getPackage();
        Intrinsics.checkExpressionValueIsNotNull((Object)genericAttributeValue, (String)"manifest.`package`");
        if ((String)genericAttributeValue.getValue() == null) {
            return;
        }
        PsiFile psiFile = expression.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile contextFile = psiFile;
        AndroidResourceUtil.MyReferredResourceFieldInfo info = AndroidUtilKt.getReferredResourceOrManifestField(facet, expression, true);
        if (info == null || info.isFromManifest()) {
            return;
        }
        ResourceType resourceType = ResourceType.getEnum((String)info.getClassName());
        if (AndroidResourceUtil.ALL_VALUE_RESOURCE_TYPES.contains(resourceType)) {
            registrar.register((IntentionAction)new CreateValueResourceQuickFix(facet, resourceType, info.getFieldName(), contextFile, true));
        }
        Map map2 = AndroidResourceUtil.XML_FILE_RESOURCE_TYPES;
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"AndroidResourceUtil.XML_FILE_RESOURCE_TYPES");
        Map map3 = map = map2;
        if (map3.containsKey(resourceType) && (resourceFolderType = ResourceFolderType.getTypeByName((String)resourceType.getName())) != null) {
            registrar.register((IntentionAction)new CreateFileResourceQuickFix(facet, resourceFolderType, info.getFieldName(), contextFile, true));
        }
    }

    @NotNull
    public Class<KtSimpleNameReference> getReferenceClass() {
        return KtSimpleNameReference.class;
    }
}

