/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.interpret.SimplePeekCallTraceInterpreter;
import com.intellij.debugger.streams.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueException;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.Map;
import java.util.PrimitiveIterator;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public class CollectIdentityTraceInterpreter
implements CallTraceInterpreter {
    private final SimplePeekCallTraceInterpreter myPeekResolver = new SimplePeekCallTraceInterpreter();

    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call2, @NotNull Value value) {
        if (call2 == null) {
            CollectIdentityTraceInterpreter.$$$reportNull$$$0(0);
        }
        if (value == null) {
            CollectIdentityTraceInterpreter.$$$reportNull$$$0(1);
        }
        if (!(value instanceof ArrayReference)) {
            throw new UnexpectedValueTypeException("Array reference expected. But " + value.type().name() + " received");
        }
        ArrayReference array2 = (ArrayReference)value;
        TraceInfo resolved = this.myPeekResolver.resolve(call2, array2.getValue(0));
        Map<Integer, TraceElement> before = resolved.getValuesOrderBefore();
        if (before.isEmpty()) {
            TraceInfo traceInfo = resolved;
            if (traceInfo == null) {
                CollectIdentityTraceInterpreter.$$$reportNull$$$0(2);
            }
            return traceInfo;
        }
        int timeAfter = CollectIdentityTraceInterpreter.extractTime(array2) + 1;
        PrimitiveIterator.OfInt iterator = IntStreamEx.of(before.keySet()).sorted().iterator();
        HashMap<Integer, TraceElement> after = new HashMap<Integer, TraceElement>(before.size());
        while (iterator.hasNext()) {
            int timeBefore = iterator.next();
            TraceElement elementBefore = before.get(timeBefore);
            TraceElementImpl elementAfter = new TraceElementImpl(timeAfter, elementBefore.getValue());
            after.put(timeAfter, elementAfter);
            ++timeAfter;
        }
        ValuesOrderInfo valuesOrderInfo = new ValuesOrderInfo(call2, before, after);
        if (valuesOrderInfo == null) {
            CollectIdentityTraceInterpreter.$$$reportNull$$$0(3);
        }
        return valuesOrderInfo;
    }

    private static int extractTime(@NotNull ArrayReference value) {
        Value time;
        Value timeArray;
        if (value == null) {
            CollectIdentityTraceInterpreter.$$$reportNull$$$0(4);
        }
        if ((timeArray = value.getValue(1)) instanceof ArrayReference && (time = ((ArrayReference)timeArray).getValue(0)) instanceof IntegerValue) {
            return ((IntegerValue)time).value();
        }
        throw new UnexpectedValueException("Could not find a maximum time value");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/trace/impl/interpret/CollectIdentityTraceInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/trace/impl/interpret/CollectIdentityTraceInterpreter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractTime";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

