/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.streams.resolve.ResolvedStreamCall;
import com.intellij.debugger.streams.resolve.ResolvedStreamChain;
import com.intellij.debugger.streams.trace.IntermediateState;
import com.intellij.debugger.streams.trace.NextAwareState;
import com.intellij.debugger.streams.trace.PrevAwareState;
import com.intellij.debugger.streams.trace.ResolvedTracingResult;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaTypes;
import com.intellij.debugger.streams.ui.TraceController;
import com.intellij.debugger.streams.ui.impl.CollectionTree;
import com.intellij.debugger.streams.ui.impl.CollectionView;
import com.intellij.debugger.streams.ui.impl.ExceptionView;
import com.intellij.debugger.streams.ui.impl.FlatView;
import com.intellij.debugger.streams.ui.impl.StreamTracesMappingView;
import com.intellij.debugger.streams.ui.impl.TraceControllerImpl;
import com.intellij.debugger.streams.wrapper.QualifierExpression;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBDimension;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import icons.JavaDebuggerStreamsIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluationAwareTraceWindow
extends DialogWrapper {
    private static final String DIALOG_TITLE = "Stream Trace";
    private static final String IS_FLAT_MODE_PROPERTY = "org.jetbrains.debugger.streams:isTraceWindowInFlatMode";
    private static final boolean IS_DEFAULT_MODE_FLAT = false;
    private static final int DEFAULT_WIDTH = 870;
    private static final int DEFAULT_HEIGHT = 400;
    private static final String FLAT_MODE_NAME = "Flat Mode";
    private static final String TABBED_MODE_NAME = "Split Mode";
    private final MyCenterPane myCenterPane;
    private final List<MyPlaceholder> myTabContents;
    private final MyPlaceholder myFlatContent;
    private final JBTabsPaneImpl myTabsPane;
    private MyMode myMode;

    public EvaluationAwareTraceWindow(@NotNull XDebugSession session, @NotNull StreamChain chain) {
        if (session == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(0);
        }
        if (chain == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(1);
        }
        super(session.getProject(), true);
        this.myTabsPane = new JBTabsPaneImpl(session.getProject(), 1, this.getDisposable());
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                ApplicationManager.getApplication().invokeLater(() -> EvaluationAwareTraceWindow.this.close(1));
            }
        }, this.myDisposable);
        this.setModal(false);
        this.setTitle(DIALOG_TITLE);
        this.myCenterPane = new MyCenterPane();
        this.myCenterPane.add(MyMode.SPLIT.name(), this.myTabsPane.getComponent());
        this.myTabContents = new ArrayList<MyPlaceholder>();
        QualifierExpression qualifierExpression = chain.getQualifierExpression();
        MyPlaceholder firstTab = new MyPlaceholder();
        this.myTabsPane.insertTab(TraceUtil.formatQualifierExpression(qualifierExpression.getText(), 30), JavaDebuggerStreamsIcons.Tab, (Component)firstTab, qualifierExpression.getText(), 0);
        this.myTabContents.add(firstTab);
        int chainLength = chain.length();
        for (int i = 0; i < chainLength; ++i) {
            StreamCall call2 = chain.getCall(i);
            MyPlaceholder tab = new MyPlaceholder();
            String callName = call2.getName().replace(" ", "");
            this.myTabsPane.insertTab(callName, JavaDebuggerStreamsIcons.Tab, (Component)tab, TraceUtil.formatWithArguments(call2), i + 1);
            this.myTabContents.add(tab);
        }
        this.myFlatContent = new MyPlaceholder();
        this.myCenterPane.add(MyMode.FLAT.name(), this.myFlatContent);
        this.myCenterPane.setPreferredSize((Dimension)new JBDimension(870, 400));
        if (!PropertiesComponent.getInstance().isValueSet(IS_FLAT_MODE_PROPERTY)) {
            PropertiesComponent.getInstance().setValue(IS_FLAT_MODE_PROPERTY, false);
        }
        this.myMode = PropertiesComponent.getInstance().getBoolean(IS_FLAT_MODE_PROPERTY) ? MyMode.FLAT : MyMode.SPLIT;
        EvaluationAwareTraceWindow.updateWindowMode(this.myCenterPane, this.myMode);
        this.init();
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.streams.ui.EvaluationAwareTraceWindow";
    }

    public void setTrace(@NotNull ResolvedTracingResult resolvedTrace, @NotNull EvaluationContextImpl context) {
        if (resolvedTrace == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(2);
        }
        if (context == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(3);
        }
        if (Disposer.isDisposed((Disposable)this.myDisposable)) {
            return;
        }
        ResolvedStreamChain chain = resolvedTrace.getResolvedChain();
        assert (chain.length() == this.myTabContents.size());
        List<TraceControllerImpl> controllers = this.createControllers(resolvedTrace);
        if (controllers.isEmpty()) {
            return;
        }
        List<TraceElement> trace = controllers.get(0).getTrace();
        CollectionTree tree = new CollectionTree(trace, context);
        CollectionView sourceView = new CollectionView(tree);
        controllers.get(0).register(sourceView);
        this.myTabContents.get(0).setContent(sourceView, "Center");
        for (int i = 1; i < this.myTabContents.size() && (i != this.myTabContents.size() - 1 || !resolvedTrace.exceptionThrown() && !resolvedTrace.getSourceChain().getTerminationCall().getResultType().equals(JavaTypes.INSTANCE.getVOID())); ++i) {
            MyPlaceholder tab = this.myTabContents.get(i);
            TraceController previous = controllers.get(i - 1);
            TraceController current = controllers.get(i);
            StreamTracesMappingView view = new StreamTracesMappingView(context, previous, current);
            tab.setContent(view, "Center");
        }
        TraceElement result = resolvedTrace.getResult();
        MyPlaceholder resultTab = this.myTabContents.get(this.myTabContents.size() - 1);
        if (resolvedTrace.exceptionThrown()) {
            resultTab.setContent((JComponent)new JBLabel("There is no result: exception was thrown", 0), "Center");
            this.setTitle("Stream Trace - Exception was thrown. Trace can be incomplete");
            ExceptionView exceptionView = new ExceptionView(context, result);
            Disposer.register((Disposable)this.myDisposable, (Disposable)exceptionView);
            this.myTabsPane.insertTab("Exception", AllIcons.Nodes.ErrorIntroduction, (Component)exceptionView, "", 0);
            this.myTabsPane.setSelectedIndex(0);
        } else if (resolvedTrace.getSourceChain().getTerminationCall().getResultType().equals(JavaTypes.INSTANCE.getVOID())) {
            resultTab.setContent((JComponent)new JBLabel("There is no result of such stream chain", 0), "Center");
        }
        FlatView flatView = new FlatView(controllers, context);
        this.myFlatContent.setContent(flatView, "Center");
        this.myCenterPane.revalidate();
        this.myCenterPane.repaint();
    }

    public void setFailMessage(@NotNull String reason) {
        if (reason == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(4);
        }
        StreamEx.of(this.myTabContents).prepend((Object)this.myFlatContent).forEach(x -> {
            if (reason == null) {
                EvaluationAwareTraceWindow.$$$reportNull$$$0(13);
            }
            x.setContent((JComponent)new JBLabel(reason, 0), "Center");
        });
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, "Close", 1)};
        if (actionArray == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(5);
        }
        return actionArray;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{new MyToggleViewAction()};
        if (actionArray == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(6);
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCenterPane;
    }

    @NotNull
    private List<TraceControllerImpl> createControllers(@NotNull ResolvedTracingResult resolvedResult) {
        if (resolvedResult == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(7);
        }
        ArrayList<TraceControllerImpl> controllers = new ArrayList<TraceControllerImpl>();
        ResolvedStreamChain chain = resolvedResult.getResolvedChain();
        List<ResolvedStreamCall.Intermediate> intermediateCalls = chain.getIntermediateCalls();
        NextAwareState firstState = intermediateCalls.isEmpty() ? chain.getTerminator().getStateBefore() : intermediateCalls.get(0).getStateBefore();
        TraceControllerImpl firstController = new TraceControllerImpl(firstState);
        controllers.add(firstController);
        TraceControllerImpl prevController = firstController;
        for (ResolvedStreamCall.Intermediate intermediate : intermediateCalls) {
            PrevAwareState after = intermediate.getStateAfter();
            TraceControllerImpl controller = new TraceControllerImpl(after);
            prevController.setNextController(controller);
            controller.setPreviousController(prevController);
            prevController = controller;
            controllers.add(controller);
        }
        ResolvedStreamCall.Terminator terminator = chain.getTerminator();
        Object afterTerminationState = terminator.getStateAfter();
        if (afterTerminationState != null && !((TerminatorStreamCall)terminator.getCall()).getResultType().equals(JavaTypes.INSTANCE.getVOID())) {
            TraceControllerImpl terminationController = new TraceControllerImpl((IntermediateState)afterTerminationState);
            terminationController.setPreviousController(prevController);
            prevController.setNextController(terminationController);
            controllers.add(terminationController);
        }
        controllers.forEach(x -> Disposer.register((Disposable)this.myDisposable, (Disposable)x));
        ArrayList<TraceControllerImpl> arrayList = controllers;
        if (arrayList == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static void updateWindowMode(@NotNull MyCenterPane pane, @NotNull MyMode mode) {
        if (pane == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(9);
        }
        if (mode == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(10);
        }
        pane.getLayout().show((Container)pane, mode.name());
        PropertiesComponent.getInstance().setValue(IS_FLAT_MODE_PROPERTY, MyMode.FLAT.equals((Object)mode));
    }

    @NotNull
    private static String getButtonText(@NotNull MyMode mode) {
        if (mode == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(11);
        }
        String string = MyMode.SPLIT.equals((Object)mode) ? FLAT_MODE_NAME : TABBED_MODE_NAME;
        if (string == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedTrace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/ui/impl/EvaluationAwareTraceWindow";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedResult";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/ui/impl/EvaluationAwareTraceWindow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createControllers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getButtonText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTrace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFailMessage";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createControllers";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateWindowMode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getButtonText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setFailMessage$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCenterPane
    extends JPanel {
        MyCenterPane() {
            super((LayoutManager)new JBCardLayout());
        }

        public JBCardLayout getLayout() {
            return (JBCardLayout)super.getLayout();
        }
    }

    private static enum MyMode {
        FLAT,
        SPLIT;

    }

    private static class MyPlaceholder
    extends JPanel {
        MyPlaceholder() {
            super(new BorderLayout());
            this.add((Component)new JBLabel("Evaluation in process", 0), "Center");
        }

        void setContent(@NotNull JComponent view, String placement) {
            if (view == null) {
                MyPlaceholder.$$$reportNull$$$0(0);
            }
            Arrays.stream(this.getComponents()).forEach(this::remove);
            this.add((Component)view, placement);
            this.revalidate();
            this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/debugger/streams/ui/impl/EvaluationAwareTraceWindow$MyPlaceholder", "setContent"));
        }
    }

    private class MyToggleViewAction
    extends DialogWrapper.DialogWrapperAction {
        MyToggleViewAction() {
            super((DialogWrapper)EvaluationAwareTraceWindow.this, EvaluationAwareTraceWindow.getButtonText(EvaluationAwareTraceWindow.this.myMode));
        }

        protected void doAction(ActionEvent e) {
            JButton button = EvaluationAwareTraceWindow.this.getButton((Action)((Object)this));
            if (button != null) {
                EvaluationAwareTraceWindow.this.myMode = this.toggleMode(EvaluationAwareTraceWindow.this.myMode);
                button.setText(EvaluationAwareTraceWindow.getButtonText(EvaluationAwareTraceWindow.this.myMode));
            }
            EvaluationAwareTraceWindow.updateWindowMode(EvaluationAwareTraceWindow.this.myCenterPane, EvaluationAwareTraceWindow.this.myMode);
        }

        @NotNull
        private MyMode toggleMode(@NotNull MyMode mode) {
            if (mode == null) {
                MyToggleViewAction.$$$reportNull$$$0(0);
            }
            MyMode myMode = MyMode.FLAT.equals((Object)mode) ? MyMode.SPLIT : MyMode.FLAT;
            if (myMode == null) {
                MyToggleViewAction.$$$reportNull$$$0(1);
            }
            return myMode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/streams/ui/impl/EvaluationAwareTraceWindow$MyToggleViewAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/streams/ui/impl/EvaluationAwareTraceWindow$MyToggleViewAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toggleMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toggleMode";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

