/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.HistoricalFileCollectionFingerprint;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.hash.HashCode;

public class OverlappingOutputs {
    private final String propertyName;
    private final String overlappedFilePath;

    public OverlappingOutputs(String propertyName, String overlappedFilePath) {
        this.propertyName = propertyName;
        this.overlappedFilePath = overlappedFilePath;
    }

    @Nullable
    public static OverlappingOutputs detect(String propertyName, HistoricalFileCollectionFingerprint previousExecution, FileCollectionFingerprint beforeExecution) {
        Map<String, NormalizedFileSnapshot> previousSnapshots = previousExecution.getSnapshots();
        Map<String, NormalizedFileSnapshot> beforeSnapshots = beforeExecution.getSnapshots();
        for (Map.Entry<String, NormalizedFileSnapshot> beforeEntry : beforeSnapshots.entrySet()) {
            HashCode previousContentHash;
            String path = beforeEntry.getKey();
            NormalizedFileSnapshot beforeSnapshot = beforeEntry.getValue();
            HashCode contentHash = beforeSnapshot.getNormalizedContentHash();
            NormalizedFileSnapshot previousSnapshot = previousSnapshots.get(path);
            HashCode hashCode = previousContentHash = previousSnapshot == null ? null : previousSnapshot.getNormalizedContentHash();
            if (beforeSnapshot.getType() == FileType.Missing || !OverlappingOutputs.createdSincePreviousExecution(previousContentHash) && !OverlappingOutputs.changedSincePreviousExecution(contentHash, previousContentHash)) continue;
            return new OverlappingOutputs(propertyName, path);
        }
        return null;
    }

    private static boolean changedSincePreviousExecution(HashCode contentHash, HashCode previousContentHash) {
        return !contentHash.equals(previousContentHash);
    }

    private static boolean createdSincePreviousExecution(@Nullable HashCode previousContentHash) {
        return previousContentHash == null;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getOverlappedFilePath() {
        return this.overlappedFilePath;
    }

    public String toString() {
        return String.format("output property '%s' with path '%s'", this.propertyName, this.overlappedFilePath);
    }
}

