/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.IvyContextManager;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.ModuleMetadataParser;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.repositories.DefaultFlatDirArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultIvyArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenLocalArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.metadata.IvyMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.changedetection.state.isolation.IsolatableFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.authentication.AuthenticationSchemeRegistry;
import org.gradle.internal.authentication.DefaultAuthenticationContainer;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

public class DefaultBaseRepositoryFactory
implements BaseRepositoryFactory {
    private final LocalMavenRepositoryLocator localMavenRepositoryLocator;
    private final FileResolver fileResolver;
    private final Instantiator instantiator;
    private final RepositoryTransportFactory transportFactory;
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final FileStore<String> externalResourcesFileStore;
    private final MetaDataParser<MutableMavenModuleResolveMetadata> pomParser;
    private final ModuleMetadataParser metadataParser;
    private final AuthenticationSchemeRegistry authenticationSchemeRegistry;
    private final IvyContextManager ivyContextManager;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final InstantiatorFactory instantiatorFactory;
    private final FileResourceRepository fileResourceRepository;
    private final FeaturePreviews featurePreviews;
    private final MavenMutableModuleMetadataFactory mavenMetadataFactory;
    private final IvyMutableModuleMetadataFactory ivyMetadataFactory;
    private final IsolatableFactory isolatableFactory;
    private final ObjectFactory objectFactory;

    public DefaultBaseRepositoryFactory(LocalMavenRepositoryLocator localMavenRepositoryLocator, FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, FileStore<String> externalResourcesFileStore, MetaDataParser<MutableMavenModuleResolveMetadata> pomParser, ModuleMetadataParser metadataParser, AuthenticationSchemeRegistry authenticationSchemeRegistry, IvyContextManager ivyContextManager, ImmutableModuleIdentifierFactory moduleIdentifierFactory, InstantiatorFactory instantiatorFactory, FileResourceRepository fileResourceRepository, FeaturePreviews featurePreviews, MavenMutableModuleMetadataFactory mavenMetadataFactory, IvyMutableModuleMetadataFactory ivyMetadataFactory, IsolatableFactory isolatableFactory, ObjectFactory objectFactory) {
        this.localMavenRepositoryLocator = localMavenRepositoryLocator;
        this.fileResolver = fileResolver;
        this.metadataParser = metadataParser;
        this.instantiator = instantiatorFactory.decorate();
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.externalResourcesFileStore = externalResourcesFileStore;
        this.pomParser = pomParser;
        this.authenticationSchemeRegistry = authenticationSchemeRegistry;
        this.ivyContextManager = ivyContextManager;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.instantiatorFactory = instantiatorFactory;
        this.fileResourceRepository = fileResourceRepository;
        this.featurePreviews = featurePreviews;
        this.mavenMetadataFactory = mavenMetadataFactory;
        this.ivyMetadataFactory = ivyMetadataFactory;
        this.isolatableFactory = isolatableFactory;
        this.objectFactory = objectFactory;
    }

    @Override
    public FlatDirectoryArtifactRepository createFlatDirRepository() {
        return this.instantiator.newInstance(DefaultFlatDirArtifactRepository.class, this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.artifactFileStore, this.moduleIdentifierFactory, this.ivyMetadataFactory, this.instantiatorFactory, this.objectFactory);
    }

    @Override
    public ArtifactRepository createGradlePluginPortal() {
        MavenArtifactRepository mavenRepository = this.createMavenRepository(new NamedMavenRepositoryDescriber("https://plugins.gradle.org/m2"));
        mavenRepository.setUrl(System.getProperty("org.gradle.internal.plugins.portal.url.override", "https://plugins.gradle.org/m2"));
        return mavenRepository;
    }

    @Override
    public MavenArtifactRepository createMavenLocalRepository() {
        MavenArtifactRepository mavenRepository = this.instantiator.newInstance(DefaultMavenLocalArtifactRepository.class, this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.instantiatorFactory, this.artifactFileStore, this.pomParser, this.metadataParser, this.createAuthenticationContainer(), this.moduleIdentifierFactory, this.fileResourceRepository, this.featurePreviews, this.mavenMetadataFactory, this.isolatableFactory, this.objectFactory);
        File localMavenRepository = this.localMavenRepositoryLocator.getLocalMavenRepository();
        mavenRepository.setUrl(localMavenRepository);
        return mavenRepository;
    }

    @Override
    public MavenArtifactRepository createJCenterRepository() {
        MavenArtifactRepository mavenRepository = this.createMavenRepository(new NamedMavenRepositoryDescriber("https://jcenter.bintray.com/"));
        mavenRepository.setUrl("https://jcenter.bintray.com/");
        return mavenRepository;
    }

    @Override
    public MavenArtifactRepository createMavenCentralRepository() {
        MavenArtifactRepository mavenRepository = this.createMavenRepository(new NamedMavenRepositoryDescriber("https://repo.maven.apache.org/maven2/"));
        mavenRepository.setUrl("https://repo.maven.apache.org/maven2/");
        return mavenRepository;
    }

    @Override
    public MavenArtifactRepository createGoogleRepository() {
        MavenArtifactRepository mavenRepository = this.createMavenRepository(new NamedMavenRepositoryDescriber("https://dl.google.com/dl/android/maven2/"));
        mavenRepository.setUrl("https://dl.google.com/dl/android/maven2/");
        return mavenRepository;
    }

    @Override
    public IvyArtifactRepository createIvyRepository() {
        return this.instantiator.newInstance(DefaultIvyArtifactRepository.class, this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.artifactFileStore, this.externalResourcesFileStore, this.createAuthenticationContainer(), this.ivyContextManager, this.moduleIdentifierFactory, this.instantiatorFactory, this.fileResourceRepository, this.metadataParser, this.featurePreviews, this.ivyMetadataFactory, this.isolatableFactory, this.objectFactory);
    }

    @Override
    public MavenArtifactRepository createMavenRepository() {
        return this.instantiator.newInstance(DefaultMavenArtifactRepository.class, this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.instantiatorFactory, this.artifactFileStore, this.pomParser, this.metadataParser, this.createAuthenticationContainer(), this.moduleIdentifierFactory, this.externalResourcesFileStore, this.fileResourceRepository, this.featurePreviews, this.mavenMetadataFactory, this.isolatableFactory, this.objectFactory);
    }

    public MavenArtifactRepository createMavenRepository(Transformer<String, MavenArtifactRepository> describer) {
        return this.instantiator.newInstance(DefaultMavenArtifactRepository.class, describer, this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.instantiatorFactory, this.artifactFileStore, this.pomParser, this.metadataParser, this.createAuthenticationContainer(), this.moduleIdentifierFactory, this.externalResourcesFileStore, this.fileResourceRepository, this.featurePreviews, this.mavenMetadataFactory, this.isolatableFactory, this.objectFactory);
    }

    protected AuthenticationContainer createAuthenticationContainer() {
        DefaultAuthenticationContainer container = this.instantiator.newInstance(DefaultAuthenticationContainer.class, this.instantiator);
        for (Map.Entry e : this.authenticationSchemeRegistry.getRegisteredSchemes().entrySet()) {
            container.registerBinding(e.getKey(), e.getValue());
        }
        return container;
    }

    private static class NamedMavenRepositoryDescriber
    implements Transformer<String, MavenArtifactRepository> {
        private final String defaultUrl;

        private NamedMavenRepositoryDescriber(String defaultUrl) {
            this.defaultUrl = defaultUrl;
        }

        @Override
        public String transform(MavenArtifactRepository repository) {
            URI url = repository.getUrl();
            if (url == null || this.defaultUrl.equals(url.toString())) {
                return repository.getName();
            }
            return repository.getName() + '(' + url + ')';
        }
    }
}

