/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionLister;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyPatternHelper;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.ResourceExceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceVersionLister
implements VersionLister {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceVersionLister.class);
    private static final String REVISION_TOKEN = IvyPatternHelper.getTokenString((String)"revision");
    public static final int REV_TOKEN_LENGTH = REVISION_TOKEN.length();
    private final ExternalResourceRepository repository;
    private final String fileSeparator = "/";
    private final Set<ExternalResourceName> visitedDirectories = new HashSet<ExternalResourceName>();

    public ResourceVersionLister(ExternalResourceRepository repository) {
        this.repository = repository;
    }

    @Override
    public void listVersions(ModuleIdentifier module, IvyArtifactName artifact, List<ResourcePattern> patterns, BuildableModuleVersionListingResolveResult result) {
        ArrayList collector = Lists.newArrayList();
        for (ResourcePattern pattern : patterns) {
            this.visit(pattern, artifact, module, collector, result);
        }
        if (!collector.isEmpty()) {
            result.listed(collector);
        }
    }

    private void visit(ResourcePattern pattern, IvyArtifactName artifact, ModuleIdentifier module, List<String> collector, BuildableModuleVersionListingResolveResult result) {
        ExternalResourceName versionListPattern = pattern.toVersionListPattern(module, artifact);
        LOGGER.debug("Listing all in {}", (Object)versionListPattern);
        try {
            List<String> versionStrings = this.listRevisionToken(versionListPattern, result);
            for (String versionString : versionStrings) {
                collector.add(versionString);
            }
        }
        catch (Exception e) {
            throw ResourceExceptions.failure(versionListPattern.getUri(), String.format("Could not list versions using %s.", pattern), e);
        }
    }

    private List<String> listRevisionToken(ExternalResourceName versionListPattern, BuildableModuleVersionListingResolveResult result) {
        String pattern = versionListPattern.getPath();
        if (!pattern.contains(REVISION_TOKEN)) {
            LOGGER.debug("revision token not defined in pattern {}.", (Object)pattern);
            return Collections.emptyList();
        }
        String prefix = pattern.substring(0, pattern.indexOf(REVISION_TOKEN));
        if (this.revisionMatchesDirectoryName(pattern)) {
            ExternalResourceName parent = versionListPattern.getRoot().resolve(prefix);
            return this.listAll(parent, result);
        }
        int parentFolderSlashIndex = prefix.lastIndexOf("/");
        String revisionParentFolder = parentFolderSlashIndex == -1 ? "" : prefix.substring(0, parentFolderSlashIndex + 1);
        ExternalResourceName parent = versionListPattern.getRoot().resolve(revisionParentFolder);
        LOGGER.debug("using {} to list all in {} ", (Object)this.repository, (Object)revisionParentFolder);
        if (!this.visitedDirectories.add(parent)) {
            return Collections.emptyList();
        }
        result.attempted(parent);
        List<String> all = this.repository.resource(parent).list();
        if (all == null) {
            return Collections.emptyList();
        }
        LOGGER.debug("found {} urls", (Object)all.size());
        Pattern regexPattern = this.createRegexPattern(pattern, parentFolderSlashIndex);
        List<String> ret = this.filterMatchedValues(all, regexPattern);
        LOGGER.debug("{} matched {}", (Object)ret.size(), (Object)pattern);
        return ret;
    }

    private List<String> filterMatchedValues(List<String> all, Pattern p) {
        ArrayList<String> ret = new ArrayList<String>(all.size());
        for (String path : all) {
            Matcher m = p.matcher(path);
            if (!m.matches()) continue;
            String value = m.group(1);
            ret.add(value);
        }
        return ret;
    }

    private Pattern createRegexPattern(String pattern, int prefixLastSlashIndex) {
        int endNameIndex = pattern.indexOf("/", prefixLastSlashIndex + 1);
        String namePattern = endNameIndex != -1 ? pattern.substring(prefixLastSlashIndex + 1, endNameIndex) : pattern.substring(prefixLastSlashIndex + 1);
        namePattern = namePattern.replaceAll("\\.", "\\\\.");
        String acceptNamePattern = namePattern.replaceAll("\\[revision\\]", "(.+)");
        return Pattern.compile(acceptNamePattern);
    }

    private boolean revisionMatchesDirectoryName(String pattern) {
        int startToken = pattern.indexOf(REVISION_TOKEN);
        if (startToken > 0 && !pattern.substring(startToken - 1, startToken).equals("/")) {
            return false;
        }
        int endToken = startToken + REV_TOKEN_LENGTH;
        return endToken >= pattern.length() || pattern.substring(endToken, endToken + 1).equals("/");
    }

    private List<String> listAll(ExternalResourceName parent, BuildableModuleVersionListingResolveResult result) {
        if (!this.visitedDirectories.add(parent)) {
            return Collections.emptyList();
        }
        LOGGER.debug("using {} to list all in {}", (Object)this.repository, (Object)parent);
        result.attempted(parent.toString());
        List<String> paths = this.repository.resource(parent).list();
        if (paths == null) {
            return Collections.emptyList();
        }
        LOGGER.debug("found {} resources", (Object)paths.size());
        return paths;
    }
}

