/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.changes.StatefulIncrementalTaskInputs;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebuildIncrementalTaskInputs
extends StatefulIncrementalTaskInputs {
    private static final Logger LOGGER = LoggerFactory.getLogger(RebuildIncrementalTaskInputs.class);
    private final FileCollection inputFiles;

    public RebuildIncrementalTaskInputs(Task task, TaskProperties taskProperties) {
        LOGGER.info("All input files are considered out-of-date for incremental {}.", (Object)task);
        this.inputFiles = taskProperties.getInputFiles();
    }

    @Override
    public boolean isIncremental() {
        return false;
    }

    @Override
    public void doOutOfDate(Action<? super InputFileDetails> outOfDateAction) {
        for (File file : this.inputFiles) {
            outOfDateAction.execute(new RebuildInputFile(file));
        }
    }

    @Override
    public void doRemoved(Action<? super InputFileDetails> removedAction) {
    }

    private static class RebuildInputFile
    implements InputFileDetails {
        private final File file;

        private RebuildInputFile(File file) {
            this.file = file;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public boolean isAdded() {
            return false;
        }

        @Override
        public boolean isModified() {
            return false;
        }

        @Override
        public boolean isRemoved() {
            return false;
        }
    }
}

