/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.changedetection.state.isolation.IsolationException;
import org.gradle.caching.internal.BuildCacheHasher;

public class ArrayValueSnapshot
implements ValueSnapshot,
Isolatable<Object[]> {
    public static final ArrayValueSnapshot EMPTY = new ArrayValueSnapshot(new ValueSnapshot[0]);
    private final ValueSnapshot[] elements;

    public ArrayValueSnapshot(ValueSnapshot[] elements) {
        this.elements = elements;
    }

    public ValueSnapshot[] getElements() {
        return this.elements;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putString("Array");
        hasher.putInt(this.elements.length);
        for (ValueSnapshot element : this.elements) {
            element.appendToHasher(hasher);
        }
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot other = snapshotter.snapshot(value);
        if (this.isEqualArrayValueSnapshot(other)) {
            return this;
        }
        return other;
    }

    private boolean isEqualArrayValueSnapshot(ValueSnapshot other) {
        if (other instanceof ArrayValueSnapshot) {
            ArrayValueSnapshot otherArray = (ArrayValueSnapshot)other;
            if (Arrays.equals(this.elements, otherArray.elements)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ArrayValueSnapshot other = (ArrayValueSnapshot)obj;
        return Arrays.equals(this.elements, other.elements);
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    @Override
    public Object[] isolate() {
        ValueSnapshot[] elements = this.getElements();
        Object[] toReturn = new Object[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            ValueSnapshot snapshot = elements[i];
            if (!(snapshot instanceof Isolatable)) {
                throw new IsolationException(snapshot);
            }
            toReturn[i] = ((Isolatable)((Object)snapshot)).isolate();
        }
        return toReturn;
    }

    @Override
    @Nullable
    public <S> Isolatable<S> coerce(Class<S> type) {
        return null;
    }
}

