/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state.mirror;

import java.io.File;
import java.io.InputStream;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.changedetection.state.mirror.FileSystemSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.MerkleDirectorySnapshotBuilder;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalDirectorySnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshotVisitor;
import org.gradle.api.internal.changedetection.state.mirror.RelativePathSegmentsTracker;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.file.FileType;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.util.GFileUtils;

public class FileSystemSnapshotFilter {
    private FileSystemSnapshotFilter() {
    }

    public static FileSystemSnapshot filterSnapshot(final Spec<FileTreeElement> spec, FileSystemSnapshot unfiltered, final FileSystem fileSystem) {
        final MerkleDirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        final MutableBoolean hasBeenFiltered = new MutableBoolean(false);
        unfiltered.accept(new PhysicalSnapshotVisitor(){
            private final RelativePathSegmentsTracker relativePathTracker = new RelativePathSegmentsTracker();

            @Override
            public boolean preVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
                boolean root = this.relativePathTracker.isRoot();
                this.relativePathTracker.enter(directorySnapshot);
                if (root || spec.isSatisfiedBy(new LogicalFileTreeElement(directorySnapshot, this.relativePathTracker.getRelativePath(), fileSystem))) {
                    builder.preVisitDirectory(directorySnapshot);
                    return true;
                }
                hasBeenFiltered.set(true);
                this.relativePathTracker.leave();
                return false;
            }

            @Override
            public void visit(PhysicalSnapshot fileSnapshot) {
                boolean root = this.relativePathTracker.isRoot();
                this.relativePathTracker.enter(fileSnapshot);
                if (root || spec.isSatisfiedBy(new LogicalFileTreeElement(fileSnapshot, this.relativePathTracker.getRelativePath(), fileSystem))) {
                    builder.visit(fileSnapshot);
                } else {
                    hasBeenFiltered.set(true);
                }
                this.relativePathTracker.leave();
            }

            @Override
            public void postVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
                this.relativePathTracker.leave();
                builder.postVisitDirectory();
            }
        });
        if (builder.getResult() == null) {
            return FileSystemSnapshot.EMPTY;
        }
        return hasBeenFiltered.get() ? builder.getResult() : unfiltered;
    }

    private static class LogicalFileTreeElement
    extends AbstractFileTreeElement {
        private final Iterable<String> _relativePathIterable;
        private final FileSystem _fileSystem;
        private final PhysicalSnapshot _snapshot;
        private RelativePath _relativePath;
        private File _file;

        public LogicalFileTreeElement(PhysicalSnapshot snapshot, Iterable<String> relativePathIterable, FileSystem fileSystem) {
            super(fileSystem);
            this._snapshot = snapshot;
            this._relativePathIterable = relativePathIterable;
            this._fileSystem = fileSystem;
        }

        @Override
        public String getDisplayName() {
            return "file '" + this.getFile() + "'";
        }

        @Override
        public File getFile() {
            if (this._file == null) {
                this._file = new File(this._snapshot.getAbsolutePath());
            }
            return this._file;
        }

        @Override
        public boolean isDirectory() {
            return this._snapshot.getType() == FileType.Directory;
        }

        @Override
        public long getLastModified() {
            return this.getFile().lastModified();
        }

        @Override
        public long getSize() {
            return this.getFile().length();
        }

        @Override
        public InputStream open() {
            return GFileUtils.openInputStream(this.getFile());
        }

        @Override
        public RelativePath getRelativePath() {
            if (this._relativePath == null) {
                this._relativePath = new RelativePath(!this.isDirectory(), (String[])Iterables.toArray(this._relativePathIterable, String.class));
            }
            return this._relativePath;
        }

        @Override
        public int getMode() {
            return this._fileSystem.getUnixMode(this.getFile());
        }
    }
}

