/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public abstract class DependentsSet {
    public static DependentsSet dependents(String ... dependentClasses) {
        if (dependentClasses.length == 0) {
            return DependentsSet.empty();
        }
        return new DefaultDependentsSet((Set)ImmutableSet.copyOf((Object[])dependentClasses));
    }

    public static DependentsSet dependents(Set<String> dependentClasses) {
        if (dependentClasses.isEmpty()) {
            return DependentsSet.empty();
        }
        return new DefaultDependentsSet((Set)ImmutableSet.copyOf(dependentClasses));
    }

    public static DependentsSet dependencyToAll() {
        return DependencyToAll.INSTANCE;
    }

    public static DependentsSet dependencyToAll(String reason) {
        return new DependencyToAll(reason);
    }

    public static DependentsSet empty() {
        return EmptyDependentsSet.INSTANCE;
    }

    public abstract Set<String> getDependentClasses();

    public abstract boolean isDependencyToAll();

    @Nullable
    public abstract String getDescription();

    private DependentsSet() {
    }

    private static class DependencyToAll
    extends DependentsSet {
        private static final DependencyToAll INSTANCE = new DependencyToAll();
        private final String reason;

        private DependencyToAll(String reason) {
            this.reason = reason;
        }

        private DependencyToAll() {
            this((String)null);
        }

        @Override
        public Set<String> getDependentClasses() {
            throw new UnsupportedOperationException("This instance of dependents set does not have dependent classes information.");
        }

        @Override
        public boolean isDependencyToAll() {
            return true;
        }

        @Override
        public String getDescription() {
            return this.reason;
        }
    }

    private static class DefaultDependentsSet
    extends DependentsSet {
        private final Set<String> dependentClasses;

        private DefaultDependentsSet(Set<String> dependentClasses) {
            this.dependentClasses = dependentClasses;
        }

        @Override
        public Set<String> getDependentClasses() {
            return this.dependentClasses;
        }

        @Override
        public boolean isDependencyToAll() {
            return false;
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    private static class EmptyDependentsSet
    extends DependentsSet {
        private static final EmptyDependentsSet INSTANCE = new EmptyDependentsSet();

        private EmptyDependentsSet() {
        }

        @Override
        public Set<String> getDependentClasses() {
            return Collections.emptySet();
        }

        @Override
        public boolean isDependencyToAll() {
            return false;
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }
    }
}

