/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.List;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CompilationSourceDirs;
import org.gradle.util.RelativePathUtil;

public class SourceToNameConverter {
    private CompilationSourceDirs sourceDirs;

    public SourceToNameConverter(CompilationSourceDirs sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    public String getClassName(File javaSourceClass) {
        List<File> dirs = this.sourceDirs.getSourceRoots();
        for (File sourceDir : dirs) {
            String relativePath;
            if (!javaSourceClass.getAbsolutePath().startsWith(sourceDir.getAbsolutePath()) || (relativePath = RelativePathUtil.relativePath(sourceDir, javaSourceClass)).startsWith("..")) continue;
            return relativePath.replaceAll("/", ".").replaceAll("\\.java$", "");
        }
        throw new IllegalArgumentException(String.format("Unable to find source java class: '%s' because it does not belong to any of the source dirs: '%s'", javaSourceClass, dirs));
    }
}

