/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.scala.DaemonScalaCompiler;
import org.gradle.api.internal.tasks.scala.NormalizingScalaCompiler;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.ZincScalaCompiler;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;

public class ScalaCompilerFactory
implements CompilerFactory<ScalaJavaJointCompileSpec> {
    private final WorkerDaemonFactory workerDaemonFactory;
    private FileCollection scalaClasspath;
    private FileCollection zincClasspath;
    private final File daemonWorkingDir;
    private final File gradleUserHomeDir;
    private final FileResolver fileResolver;

    public ScalaCompilerFactory(File daemonWorkingDir, WorkerDaemonFactory workerDaemonFactory, FileCollection scalaClasspath, FileCollection zincClasspath, File gradleUserHomeDir, FileResolver fileResolver) {
        this.daemonWorkingDir = daemonWorkingDir;
        this.workerDaemonFactory = workerDaemonFactory;
        this.scalaClasspath = scalaClasspath;
        this.zincClasspath = zincClasspath;
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.fileResolver = fileResolver;
    }

    @Override
    public Compiler<ScalaJavaJointCompileSpec> newCompiler(ScalaJavaJointCompileSpec spec) {
        Set<File> scalaClasspathFiles = this.scalaClasspath.getFiles();
        Set<File> zincClasspathFiles = this.zincClasspath.getFiles();
        DaemonScalaCompiler<ScalaJavaJointCompileSpec> scalaCompiler = new DaemonScalaCompiler<ScalaJavaJointCompileSpec>(this.daemonWorkingDir, new ZincScalaCompiler(scalaClasspathFiles, zincClasspathFiles, this.gradleUserHomeDir), this.workerDaemonFactory, zincClasspathFiles, this.fileResolver);
        return new NormalizingScalaCompiler(scalaCompiler);
    }
}

