/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.announce.internal.jdk6;

import java.io.File;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.gradle.api.plugins.announce.internal.AnnouncerUnavailableException;
import org.gradle.api.plugins.announce.internal.Growl;
import org.gradle.api.plugins.announce.internal.IconProvider;
import org.gradle.internal.UncheckedException;

public class AppleScriptBackedGrowlAnnouncer
extends Growl {
    private final IconProvider iconProvider;
    private ScriptEngine engine;

    public AppleScriptBackedGrowlAnnouncer(IconProvider iconProvider) {
        this.iconProvider = iconProvider;
        ScriptEngineManager mgr = new ScriptEngineManager();
        this.engine = mgr.getEngineByName("AppleScript");
        if (this.engine == null) {
            this.engine = mgr.getEngineByName("AppleScriptEngine");
        }
        if (this.engine == null) {
            throw new AnnouncerUnavailableException("AppleScript engine not available on used JVM");
        }
    }

    @Override
    public void send(String title, String message) {
        String isRunning = "\ntell application \"System Events\"\nset isRunning to count of (every process whose bundle identifier is \"com.Growl.GrowlHelperApp\") > 0\nend tell\nreturn isRunning\n";
        try {
            Object value = this.engine.eval(isRunning);
            if (value.equals(0)) {
                throw new AnnouncerUnavailableException("Growl is not running.");
            }
            File icon = this.iconProvider.getIcon(48, 48);
            String iconDef = icon != null ? "image from location ((POSIX file \"" + icon.getAbsolutePath() + "\") as string) as alias" : "";
            String script = "\ntell application id \"com.Growl.GrowlHelperApp\"\nregister as application \"Gradle\" all notifications {\"Build Notification\"} default notifications {\"Build Notification\"}\nnotify with name \"Build Notification\" title \"" + AppleScriptBackedGrowlAnnouncer.escape(title) + "\" description \"" + AppleScriptBackedGrowlAnnouncer.escape(message) + "\" application name \"Gradle\"" + iconDef + "\nend tell\n";
            this.engine.eval(script);
        }
        catch (ScriptException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private static String escape(String value) {
        return value.replace("\\", "\\\\").replace("\r", "\\r");
    }
}

