/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.gradle.internal;

import java.util.List;
import org.gradle.api.plugins.buildcomparison.gradle.GradleBuildInvocationSpec;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.internal.outcomes.ProjectOutcomes;
import org.gradle.util.GradleVersion;

public class ComparableGradleBuildExecuter {
    public static final GradleVersion PROJECT_OUTCOMES_MINIMUM_VERSION = GradleVersion.version("1.2");
    public static final GradleVersion EXEC_MINIMUM_VERSION = GradleVersion.version("1.2");
    private final GradleBuildInvocationSpec spec;

    public ComparableGradleBuildExecuter(GradleBuildInvocationSpec spec) {
        this.spec = spec;
    }

    public GradleBuildInvocationSpec getSpec() {
        return this.spec;
    }

    public boolean isExecutable() {
        return this.getGradleVersion().compareTo(EXEC_MINIMUM_VERSION) >= 0;
    }

    public GradleVersion getGradleVersion() {
        return GradleVersion.version(this.getSpec().getGradleVersion());
    }

    public ProjectOutcomes executeWith(ProjectConnection connection) {
        List<String> tasksList = this.getSpec().getTasks();
        String[] tasks = tasksList.toArray(new String[0]);
        List<String> argumentsList = this.getSpec().getArguments();
        String[] arguments = argumentsList.toArray(new String[0]);
        ModelBuilder<ProjectOutcomes> modelBuilder = connection.model(ProjectOutcomes.class);
        return (ProjectOutcomes)((ModelBuilder)modelBuilder.withArguments(arguments)).forTasks(tasks).get();
    }
}

