/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.util.ConfigureUtil;

public class War
extends Jar {
    public static final String WAR_EXTENSION = "war";
    private static final Spec<File> IS_DIRECTORY = new Spec<File>(){

        @Override
        public boolean isSatisfiedBy(File element) {
            return element.isDirectory();
        }
    };
    private static final Spec<File> IS_FILE = new Spec<File>(){

        @Override
        public boolean isSatisfiedBy(File element) {
            return element.isFile();
        }
    };
    private File webXml;
    private FileCollection classpath;
    private final DefaultCopySpec webInf;

    public War() {
        this.setExtension(WAR_EXTENSION);
        this.setMetadataCharset("UTF-8");
        this.webInf = (DefaultCopySpec)this.getRootSpec().addChildBeforeSpec(this.getMainSpec()).into("WEB-INF");
        this.webInf.into((Object)"classes", (Action<? super CopySpec>)new Action<CopySpec>(){

            @Override
            public void execute(CopySpec copySpec) {
                copySpec.from(new Callable<Iterable<File>>(){

                    @Override
                    public Iterable<File> call() {
                        FileCollection classpath = War.this.getClasspath();
                        return classpath != null ? classpath.filter(IS_DIRECTORY) : Collections.emptyList();
                    }
                });
            }
        });
        this.webInf.into((Object)"lib", (Action<? super CopySpec>)new Action<CopySpec>(){

            @Override
            public void execute(CopySpec it) {
                it.from(new Callable<Iterable<File>>(){

                    @Override
                    public Iterable<File> call() {
                        FileCollection classpath = War.this.getClasspath();
                        return classpath != null ? classpath.filter(IS_FILE) : Collections.emptyList();
                    }
                });
            }
        });
        this.webInf.into((Object)"", (Action<? super CopySpec>)new Action<CopySpec>(){

            @Override
            public void execute(CopySpec it) {
                it.from(new Callable<File>(){

                    @Override
                    public File call() {
                        return War.this.getWebXml();
                    }
                });
                it.rename(new Transformer<String, String>(){

                    @Override
                    public String transform(String it) {
                        return "web.xml";
                    }
                });
            }
        });
    }

    @Internal
    public CopySpec getWebInf() {
        return this.webInf.addChild();
    }

    public CopySpec webInf(Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.getWebInf());
    }

    public CopySpec webInf(Action<? super CopySpec> configureAction) {
        CopySpec webInf = this.getWebInf();
        configureAction.execute(webInf);
        return webInf;
    }

    @Nullable
    @Optional
    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.setClasspath((Object)classpath);
    }

    public void setClasspath(Object classpath) {
        this.classpath = this.getProject().files(classpath);
    }

    public void classpath(Object ... classpath) {
        FileCollection oldClasspath = this.getClasspath();
        this.classpath = this.getProject().files(oldClasspath != null ? oldClasspath : new ArrayList(), classpath);
    }

    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    public File getWebXml() {
        return this.webXml;
    }

    public void setWebXml(@Nullable File webXml) {
        this.webXml = webXml;
    }
}

