/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.cache.internal.VersionSpecificCacheDirectory;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.apache.commons.io.filefilter.FileFilterUtils;
import org.gradle.internal.impldep.org.apache.commons.io.filefilter.IOFileFilter;
import org.gradle.internal.impldep.org.apache.commons.io.filefilter.RegexFileFilter;
import org.gradle.util.GradleVersion;

public class VersionSpecificCacheDirectoryScanner {
    private final File baseDir;

    public VersionSpecificCacheDirectoryScanner(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getDirectory(GradleVersion gradleVersion) {
        return new File(this.baseDir, gradleVersion.getVersion());
    }

    public SortedSet<VersionSpecificCacheDirectory> getExistingDirectories() {
        TreeSet result = Sets.newTreeSet();
        for (File subDir : this.listVersionSpecificCacheDirs()) {
            GradleVersion version = this.tryParseGradleVersion(subDir);
            if (version == null) continue;
            result.add(new VersionSpecificCacheDirectory(subDir, version));
        }
        return result;
    }

    private Collection<File> listVersionSpecificCacheDirs() {
        IOFileFilter combinedFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), new RegexFileFilter("^\\d.*")});
        File[] result = this.baseDir.listFiles((FileFilter)combinedFilter);
        return result == null ? Collections.emptySet() : Arrays.asList(result);
    }

    private GradleVersion tryParseGradleVersion(File dir) {
        try {
            return GradleVersion.version(dir.getName());
        }
        catch (Exception e) {
            return null;
        }
    }
}

