/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.execution.TaskSelectionResult;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class TaskNameResolver {
    public boolean tryFindUnqualifiedTaskCheaply(String name, ProjectInternal project) {
        for (Project project1 : project.getAllprojects()) {
            if (!project1.getTasks().getNames().contains(name)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public TaskSelectionResult selectWithName(final String taskName, final ProjectInternal project, boolean includeSubProjects) {
        if (includeSubProjects) {
            LinkedHashSet tasks = Sets.newLinkedHashSet();
            new MultiProjectTaskSelectionResult(taskName, project, false).collectTasks(tasks);
            if (!tasks.isEmpty()) {
                return new FixedTaskSelectionResult(tasks);
            }
        } else {
            TaskNameResolver.discoverTasks(project);
            if (TaskNameResolver.hasTask(taskName, project)) {
                return new TaskSelectionResult(){

                    @Override
                    public void collectTasks(Collection<? super Task> tasks) {
                        tasks.add(TaskNameResolver.getExistingTask(project, taskName));
                    }
                };
            }
        }
        return null;
    }

    public Map<String, TaskSelectionResult> selectAll(ProjectInternal project, boolean includeSubProjects) {
        LinkedHashMap selected = Maps.newLinkedHashMap();
        if (includeSubProjects) {
            LinkedHashSet taskNames = Sets.newLinkedHashSet();
            this.collectTaskNames(project, taskNames);
            for (String taskName : taskNames) {
                selected.put(taskName, new MultiProjectTaskSelectionResult(taskName, project, true));
            }
        } else {
            TaskNameResolver.discoverTasks(project);
            for (String taskName : TaskNameResolver.getTaskNames(project)) {
                selected.put(taskName, new SingleProjectTaskSelectionResult(taskName, project.getTasks()));
            }
        }
        return selected;
    }

    private static void discoverTasks(ProjectInternal project) {
        try {
            project.getTasks().discoverTasks();
        }
        catch (Throwable e) {
            throw new ProjectConfigurationException(String.format("A problem occurred configuring %s.", project), e);
        }
    }

    private static Set<String> getTaskNames(ProjectInternal project) {
        return project.getTasks().getNames();
    }

    private static boolean hasTask(String taskName, ProjectInternal project) {
        return project.getTasks().getNames().contains(taskName) || project.getTasks().findByName(taskName) != null;
    }

    private static TaskInternal getExistingTask(ProjectInternal project, String taskName) {
        try {
            return (TaskInternal)project.getTasks().getByName(taskName);
        }
        catch (Throwable e) {
            throw new ProjectConfigurationException(String.format("A problem occurred configuring %s.", project), e);
        }
    }

    private void collectTaskNames(ProjectInternal project, Set<String> result) {
        TaskNameResolver.discoverTasks(project);
        result.addAll(TaskNameResolver.getTaskNames(project));
        for (Project subProject : project.getChildProjects().values()) {
            this.collectTaskNames((ProjectInternal)subProject, result);
        }
    }

    private static class MultiProjectTaskSelectionResult
    implements TaskSelectionResult {
        private final ProjectInternal project;
        private final String taskName;
        private final boolean discovered;

        MultiProjectTaskSelectionResult(String taskName, ProjectInternal project, boolean discovered) {
            this.project = project;
            this.taskName = taskName;
            this.discovered = discovered;
        }

        @Override
        public void collectTasks(Collection<? super Task> tasks) {
            this.collect(this.project, tasks);
        }

        private void collect(ProjectInternal project, Collection<? super Task> tasks) {
            if (!this.discovered) {
                TaskNameResolver.discoverTasks(project);
            }
            if (TaskNameResolver.hasTask(this.taskName, project)) {
                TaskInternal task = TaskNameResolver.getExistingTask(project, this.taskName);
                tasks.add(task);
                if (task.getImpliesSubProjects()) {
                    return;
                }
            }
            for (Project subProject : project.getChildProjects().values()) {
                this.collect((ProjectInternal)subProject, tasks);
            }
        }
    }

    private static class SingleProjectTaskSelectionResult
    implements TaskSelectionResult {
        private final TaskContainer taskContainer;
        private final String taskName;

        SingleProjectTaskSelectionResult(String taskName, TaskContainer tasksContainer) {
            this.taskContainer = tasksContainer;
            this.taskName = taskName;
        }

        @Override
        public void collectTasks(Collection<? super Task> tasks) {
            tasks.add((Task)this.taskContainer.getByName(this.taskName));
        }
    }

    private static class FixedTaskSelectionResult
    implements TaskSelectionResult {
        private final Collection<Task> tasks;

        FixedTaskSelectionResult(Collection<Task> tasks) {
            this.tasks = tasks;
        }

        @Override
        public void collectTasks(Collection<? super Task> tasks) {
            tasks.addAll(this.tasks);
        }
    }
}

