/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.io.File;
import java.io.FileNotFoundException;
import org.gradle.api.UncheckedIOException;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.ScriptSourceHasher;
import org.gradle.internal.hash.ContentHasherFactory;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.resource.TextResource;

public class DefaultScriptSourceHasher
implements ScriptSourceHasher {
    private final FileHasher fileHasher;
    private final ContentHasherFactory contentHasherFactory;

    public DefaultScriptSourceHasher(FileHasher fileHasher, ContentHasherFactory contentHasherFactory) {
        this.fileHasher = fileHasher;
        this.contentHasherFactory = contentHasherFactory;
    }

    @Override
    public HashCode hash(ScriptSource scriptSource) {
        TextResource resource = scriptSource.getResource();
        File file = resource.getFile();
        if (file != null) {
            try {
                return this.fileHasher.hash(file);
            }
            catch (UncheckedIOException e) {
                if (e.getCause() instanceof FileNotFoundException) {
                    throw new UncheckedIOException("Could not read " + scriptSource.getDisplayName() + " as it does not exist.", e.getCause());
                }
                throw e;
            }
        }
        Hasher hasher = (Hasher)this.contentHasherFactory.create();
        hasher.putString(resource.getText());
        return hasher.hash();
    }
}

