/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.fingerprint.impl.FilePathWithType;
import org.gradle.internal.fingerprint.impl.FingerprintCompareStrategy;
import org.gradle.internal.impldep.com.google.common.collect.ListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.MultimapBuilder;

public class NormalizedPathFingerprintCompareStrategy
implements FingerprintCompareStrategy.Impl {
    private static final Comparator<Map.Entry<NormalizedFileSnapshot, ?>> ENTRY_COMPARATOR = new Comparator<Map.Entry<NormalizedFileSnapshot, ?>>(){

        @Override
        public int compare(Map.Entry<NormalizedFileSnapshot, ?> o1, Map.Entry<NormalizedFileSnapshot, ?> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    @Override
    public boolean visitChangesSince(TaskStateChangeVisitor visitor, Map<String, NormalizedFileSnapshot> currentFingerprints, Map<String, NormalizedFileSnapshot> previousFingerprints, String propertyTitle, boolean includeAdded) {
        NormalizedFileSnapshot previousSnapshot;
        ListMultimap unaccountedForPreviousFiles = MultimapBuilder.hashKeys((int)previousFingerprints.size()).linkedListValues().build();
        ListMultimap addedFilesByNormalizedPath = MultimapBuilder.linkedHashKeys().linkedListValues().build();
        for (Map.Entry<String, NormalizedFileSnapshot> entry : previousFingerprints.entrySet()) {
            String absolutePath = entry.getKey();
            previousSnapshot = entry.getValue();
            unaccountedForPreviousFiles.put((Object)previousSnapshot, (Object)new FilePathWithType(absolutePath, previousSnapshot.getType()));
        }
        for (Map.Entry<String, NormalizedFileSnapshot> entry : currentFingerprints.entrySet()) {
            String currentAbsolutePath = entry.getKey();
            NormalizedFileSnapshot currentSnapshot = entry.getValue();
            List previousFilesForSnapshot = unaccountedForPreviousFiles.get((Object)currentSnapshot);
            if (previousFilesForSnapshot.isEmpty()) {
                addedFilesByNormalizedPath.put((Object)currentSnapshot.getNormalizedPath(), (Object)new FilePathWithType(currentAbsolutePath, currentSnapshot.getType()));
                continue;
            }
            previousFilesForSnapshot.remove(0);
        }
        ArrayList unaccountedForPreviousEntries = Lists.newArrayList((Iterable)unaccountedForPreviousFiles.entries());
        Collections.sort(unaccountedForPreviousEntries, ENTRY_COMPARATOR);
        for (Map.Entry unaccountedForPreviousSnapshotEntry : unaccountedForPreviousEntries) {
            FilePathWithType removedFile;
            FilePathWithType addedFile;
            previousSnapshot = (NormalizedFileSnapshot)unaccountedForPreviousSnapshotEntry.getKey();
            String normalizedPath = previousSnapshot.getNormalizedPath();
            List addedFilesForNormalizedPath = addedFilesByNormalizedPath.get((Object)normalizedPath);
            if (!(!addedFilesForNormalizedPath.isEmpty() ? !visitor.visitChange(FileChange.modified((addedFile = (FilePathWithType)addedFilesForNormalizedPath.remove(0)).getAbsolutePath(), propertyTitle, previousSnapshot.getType(), addedFile.getFileType())) : !visitor.visitChange(FileChange.removed((removedFile = (FilePathWithType)unaccountedForPreviousSnapshotEntry.getValue()).getAbsolutePath(), propertyTitle, removedFile.getFileType())))) continue;
            return false;
        }
        if (includeAdded) {
            for (FilePathWithType addedFile : addedFilesByNormalizedPath.values()) {
                if (visitor.visitChange(FileChange.added(addedFile.getAbsolutePath(), propertyTitle, addedFile.getFileType()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher, Collection<NormalizedFileSnapshot> snapshots) {
        NormalizedPathFingerprintCompareStrategy.appendSortedToHasher(hasher, snapshots);
    }

    public static void appendSortedToHasher(BuildCacheHasher hasher, Collection<NormalizedFileSnapshot> snapshots) {
        ArrayList normalizedSnapshots = Lists.newArrayList(snapshots);
        Collections.sort(normalizedSnapshots);
        for (NormalizedFileSnapshot normalizedSnapshot : normalizedSnapshots) {
            normalizedSnapshot.appendToHasher(hasher);
        }
    }
}

