/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.internal.impldep.org.fusesource.jansi.AnsiOutputStream;
import org.gradle.internal.impldep.org.fusesource.jansi.internal.CLibrary;
import org.gradle.internal.impldep.org.fusesource.jansi.internal.Kernel32;
import org.gradle.internal.impldep.org.fusesource.jansi.internal.WindowsSupport;

public final class AnsiConsoleUtil {
    private static final int ENABLE_VIRTUAL_TERMINAL_PROCESSING = 4;
    private static final int DISABLE_NEWLINE_AUTO_RETURN = 8;

    private AnsiConsoleUtil() {
    }

    public static OutputStream wrapOutputStream(OutputStream stream) {
        try {
            return AnsiConsoleUtil.wrapOutputStream(stream, CLibrary.STDOUT_FILENO);
        }
        catch (Throwable ignore) {
            return AnsiConsoleUtil.wrapOutputStream(stream, 0);
        }
    }

    public static OutputStream wrapOutputStream(OutputStream stream, int fileno) {
        if (Boolean.getBoolean("jansi.passthrough")) {
            return stream;
        }
        if (Boolean.getBoolean("jansi.strip")) {
            return new AnsiOutputStream(stream);
        }
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows") && !AnsiConsoleUtil.isXterm()) {
            final long stdOutputHandle = Kernel32.GetStdHandle((int)Kernel32.STD_OUTPUT_HANDLE);
            final int[] mode = new int[1];
            if (stdOutputHandle != (long)Kernel32.INVALID_HANDLE_VALUE && 0 != Kernel32.GetConsoleMode((long)stdOutputHandle, (int[])mode) && 0 != Kernel32.SetConsoleMode((long)stdOutputHandle, (int)(mode[0] | 4 | 8))) {
                return new FilterOutputStream(stream){

                    @Override
                    public void close() throws IOException {
                        this.write(AnsiOutputStream.REST_CODE);
                        this.flush();
                        Kernel32.SetConsoleMode((long)stdOutputHandle, (int)mode[0]);
                        super.close();
                    }
                };
            }
            try {
                return new WindowsAnsiOutputStream(stream);
            }
            catch (Throwable throwable) {
                return new AnsiOutputStream(stream);
            }
        }
        try {
            boolean forceColored = Boolean.getBoolean("jansi.force");
            if (!AnsiConsoleUtil.isXterm() && !forceColored && CLibrary.isatty((int)fileno) == 0) {
                return new AnsiOutputStream(stream);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new FilterOutputStream(stream){

            @Override
            public void close() throws IOException {
                this.write(AnsiOutputStream.REST_CODE);
                this.flush();
                super.close();
            }
        };
    }

    private static boolean isXterm() {
        String term = System.getenv("TERM");
        return term != null && term.startsWith("xterm");
    }

    private static class WindowsAnsiOutputStream
    extends AnsiOutputStream {
        private static final long CONSOLE = Kernel32.GetStdHandle((int)Kernel32.STD_OUTPUT_HANDLE);
        private static final short FOREGROUND_BLACK = 0;
        private static final short FOREGROUND_YELLOW = (short)(Kernel32.FOREGROUND_RED | Kernel32.FOREGROUND_GREEN);
        private static final short FOREGROUND_MAGENTA = (short)(Kernel32.FOREGROUND_BLUE | Kernel32.FOREGROUND_RED);
        private static final short FOREGROUND_CYAN = (short)(Kernel32.FOREGROUND_BLUE | Kernel32.FOREGROUND_GREEN);
        private static final short FOREGROUND_WHITE = (short)(Kernel32.FOREGROUND_RED | Kernel32.FOREGROUND_GREEN | Kernel32.FOREGROUND_BLUE);
        private static final short FOREGROUND_INTENSITY = 8;
        private static final short BACKGROUND_BLACK = 0;
        private static final short BACKGROUND_YELLOW = (short)(Kernel32.BACKGROUND_RED | Kernel32.BACKGROUND_GREEN);
        private static final short BACKGROUND_MAGENTA = (short)(Kernel32.BACKGROUND_BLUE | Kernel32.BACKGROUND_RED);
        private static final short BACKGROUND_CYAN = (short)(Kernel32.BACKGROUND_BLUE | Kernel32.BACKGROUND_GREEN);
        private static final short BACKGROUND_WHITE = (short)(Kernel32.BACKGROUND_RED | Kernel32.BACKGROUND_GREEN | Kernel32.BACKGROUND_BLUE);
        private static final short[] ANSI_FOREGROUND_COLOR_MAP = new short[]{0, Kernel32.FOREGROUND_RED, Kernel32.FOREGROUND_GREEN, FOREGROUND_YELLOW, Kernel32.FOREGROUND_BLUE, FOREGROUND_MAGENTA, FOREGROUND_CYAN, FOREGROUND_WHITE};
        private static final short[] ANSI_BACKGROUND_COLOR_MAP = new short[]{0, Kernel32.BACKGROUND_RED, Kernel32.BACKGROUND_GREEN, BACKGROUND_YELLOW, Kernel32.BACKGROUND_BLUE, BACKGROUND_MAGENTA, BACKGROUND_CYAN, BACKGROUND_WHITE};
        private final Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        private final short originalColors;
        private boolean negative;
        private short savedX = (short)-1;
        private short savedY = (short)-1;

        public WindowsAnsiOutputStream(OutputStream os) throws IOException {
            super(os);
            this.getConsoleInfo();
            this.originalColors = this.info.attributes;
        }

        private void getConsoleInfo() throws IOException {
            this.out.flush();
            if (Kernel32.GetConsoleScreenBufferInfo((long)CONSOLE, (Kernel32.CONSOLE_SCREEN_BUFFER_INFO)this.info) == 0) {
                throw new IOException("Could not get the screen info: " + WindowsSupport.getLastErrorMessage());
            }
            if (this.negative) {
                this.info.attributes = this.invertAttributeColors(this.info.attributes);
            }
        }

        private void applyAttribute() throws IOException {
            this.out.flush();
            short attributes = this.info.attributes;
            if (this.negative) {
                attributes = this.invertAttributeColors(attributes);
            }
            if (Kernel32.SetConsoleTextAttribute((long)CONSOLE, (short)attributes) == 0) {
                throw new IOException(WindowsSupport.getLastErrorMessage());
            }
        }

        private short invertAttributeColors(short attributes) {
            int fg = 0xF & attributes;
            int bg = 240 * attributes;
            attributes = (short)(attributes & 0xFF00 | (fg <<= 8) | (bg >>= 8));
            return attributes;
        }

        private void applyCursorPosition() throws IOException {
            if (Kernel32.SetConsoleCursorPosition((long)CONSOLE, (Kernel32.COORD)this.info.cursorPosition.copy()) == 0) {
                throw new IOException(WindowsSupport.getLastErrorMessage());
            }
        }

        protected void processEraseScreen(int eraseOption) throws IOException {
            this.getConsoleInfo();
            int[] written = new int[1];
            switch (eraseOption) {
                case 2: {
                    Kernel32.COORD topLeft = new Kernel32.COORD();
                    topLeft.x = 0;
                    topLeft.y = this.info.window.top;
                    int screenLength = this.info.window.height() * this.info.size.x;
                    Kernel32.FillConsoleOutputAttribute((long)CONSOLE, (short)this.originalColors, (int)screenLength, (Kernel32.COORD)topLeft, (int[])written);
                    Kernel32.FillConsoleOutputCharacterW((long)CONSOLE, (char)' ', (int)screenLength, (Kernel32.COORD)topLeft, (int[])written);
                    break;
                }
                case 1: {
                    Kernel32.COORD topLeft2 = new Kernel32.COORD();
                    topLeft2.x = 0;
                    topLeft2.y = this.info.window.top;
                    int lengthToCursor = (this.info.cursorPosition.y - this.info.window.top) * this.info.size.x + this.info.cursorPosition.x;
                    Kernel32.FillConsoleOutputAttribute((long)CONSOLE, (short)this.originalColors, (int)lengthToCursor, (Kernel32.COORD)topLeft2, (int[])written);
                    Kernel32.FillConsoleOutputCharacterW((long)CONSOLE, (char)' ', (int)lengthToCursor, (Kernel32.COORD)topLeft2, (int[])written);
                    break;
                }
                case 0: {
                    int lengthToEnd = (this.info.window.bottom - this.info.cursorPosition.y) * this.info.size.x + (this.info.size.x - this.info.cursorPosition.x);
                    Kernel32.FillConsoleOutputAttribute((long)CONSOLE, (short)this.originalColors, (int)lengthToEnd, (Kernel32.COORD)this.info.cursorPosition.copy(), (int[])written);
                    Kernel32.FillConsoleOutputCharacterW((long)CONSOLE, (char)' ', (int)lengthToEnd, (Kernel32.COORD)this.info.cursorPosition.copy(), (int[])written);
                    break;
                }
            }
        }

        protected void processEraseLine(int eraseOption) throws IOException {
            this.getConsoleInfo();
            int[] written = new int[1];
            switch (eraseOption) {
                case 2: {
                    Kernel32.COORD leftColCurrRow = this.info.cursorPosition.copy();
                    leftColCurrRow.x = 0;
                    Kernel32.FillConsoleOutputAttribute((long)CONSOLE, (short)this.originalColors, (int)this.info.size.x, (Kernel32.COORD)leftColCurrRow, (int[])written);
                    Kernel32.FillConsoleOutputCharacterW((long)CONSOLE, (char)' ', (int)this.info.size.x, (Kernel32.COORD)leftColCurrRow, (int[])written);
                    break;
                }
                case 1: {
                    Kernel32.COORD leftColCurrRow2 = this.info.cursorPosition.copy();
                    leftColCurrRow2.x = 0;
                    Kernel32.FillConsoleOutputAttribute((long)CONSOLE, (short)this.originalColors, (int)this.info.cursorPosition.x, (Kernel32.COORD)leftColCurrRow2, (int[])written);
                    Kernel32.FillConsoleOutputCharacterW((long)CONSOLE, (char)' ', (int)this.info.cursorPosition.x, (Kernel32.COORD)leftColCurrRow2, (int[])written);
                    break;
                }
                case 0: {
                    int lengthToLastCol = this.info.size.x - this.info.cursorPosition.x;
                    Kernel32.FillConsoleOutputAttribute((long)CONSOLE, (short)this.originalColors, (int)lengthToLastCol, (Kernel32.COORD)this.info.cursorPosition.copy(), (int[])written);
                    Kernel32.FillConsoleOutputCharacterW((long)CONSOLE, (char)' ', (int)lengthToLastCol, (Kernel32.COORD)this.info.cursorPosition.copy(), (int[])written);
                    break;
                }
            }
        }

        protected void processCursorLeft(int count) throws IOException {
            this.getConsoleInfo();
            this.info.cursorPosition.x = (short)Math.max(0, this.info.cursorPosition.x - count);
            this.applyCursorPosition();
        }

        protected void processCursorRight(int count) throws IOException {
            this.getConsoleInfo();
            this.info.cursorPosition.x = (short)Math.min(this.info.window.width(), this.info.cursorPosition.x + count);
            this.applyCursorPosition();
        }

        protected void processCursorDown(int count) throws IOException {
            this.getConsoleInfo();
            this.info.cursorPosition.y = (short)Math.min(Math.max(0, this.info.size.y - 1), this.info.cursorPosition.y + count);
            this.applyCursorPosition();
        }

        protected void processCursorUp(int count) throws IOException {
            this.getConsoleInfo();
            this.info.cursorPosition.y = (short)Math.max(this.info.window.top, this.info.cursorPosition.y - count);
            this.applyCursorPosition();
        }

        protected void processCursorTo(int row, int col) throws IOException {
            this.getConsoleInfo();
            this.info.cursorPosition.y = (short)Math.max(this.info.window.top, Math.min(this.info.size.y, this.info.window.top + row - 1));
            this.info.cursorPosition.x = (short)Math.max(0, Math.min(this.info.window.width(), col - 1));
            this.applyCursorPosition();
        }

        protected void processCursorToColumn(int x) throws IOException {
            this.getConsoleInfo();
            this.info.cursorPosition.x = (short)Math.max(0, Math.min(this.info.window.width(), x - 1));
            this.applyCursorPosition();
        }

        protected void processSetForegroundColor(int color, boolean bright) throws IOException {
            this.info.attributes = (short)(this.info.attributes & 0xFFFFFFF0 | ANSI_FOREGROUND_COLOR_MAP[color]);
            if (bright) {
                this.info.attributes = (short)(this.info.attributes | 8);
            }
            this.applyAttribute();
        }

        protected void processSetBackgroundColor(int color, boolean bright) throws IOException {
            this.info.attributes = (short)(this.info.attributes & 0xFFFFFF8F | ANSI_BACKGROUND_COLOR_MAP[color]);
            this.applyAttribute();
        }

        protected void processDefaultTextColor() throws IOException {
            this.info.attributes = (short)(this.info.attributes & 0xFFFFFFF0 | this.originalColors & 0xF);
            this.applyAttribute();
        }

        protected void processDefaultBackgroundColor() throws IOException {
            this.info.attributes = (short)(this.info.attributes & 0xFFFFFF0F | this.originalColors & 0xF0);
            this.applyAttribute();
        }

        protected void processAttributeRest() throws IOException {
            this.info.attributes = (short)(this.info.attributes & 0xFFFFFF00 | this.originalColors);
            this.negative = false;
            this.applyAttribute();
        }

        protected void processSetAttribute(int attribute) throws IOException {
            switch (attribute) {
                case 1: {
                    this.info.attributes = (short)(this.info.attributes | 8);
                    this.applyAttribute();
                    break;
                }
                case 22: {
                    this.info.attributes = (short)(this.info.attributes & 0xFFFFFFF7);
                    this.applyAttribute();
                    break;
                }
                case 4: {
                    this.info.attributes = (short)(this.info.attributes | Kernel32.BACKGROUND_INTENSITY);
                    this.applyAttribute();
                    break;
                }
                case 24: {
                    this.info.attributes = (short)(this.info.attributes & ~Kernel32.BACKGROUND_INTENSITY);
                    this.applyAttribute();
                    break;
                }
                case 7: {
                    this.negative = true;
                    this.applyAttribute();
                    break;
                }
                case 27: {
                    this.negative = false;
                    this.applyAttribute();
                    break;
                }
            }
        }

        protected void processSaveCursorPosition() throws IOException {
            this.getConsoleInfo();
            this.savedX = this.info.cursorPosition.x;
            this.savedY = this.info.cursorPosition.y;
        }

        protected void processRestoreCursorPosition() throws IOException {
            if (this.savedX != -1 && this.savedY != -1) {
                this.out.flush();
                this.info.cursorPosition.x = this.savedX;
                this.info.cursorPosition.y = this.savedY;
                this.applyCursorPosition();
            }
        }

        protected void processChangeWindowTitle(String label) {
            Kernel32.SetConsoleTitle((String)label);
        }
    }
}

