/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.AbstractProgressLoggingHandler;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transfer.ResourceOperation;

public class ProgressLoggingExternalResourceAccessor
extends AbstractProgressLoggingHandler
implements ExternalResourceAccessor {
    private final ExternalResourceAccessor delegate;

    public ProgressLoggingExternalResourceAccessor(ExternalResourceAccessor delegate, ProgressLoggerFactory progressLoggerFactory) {
        super(progressLoggerFactory);
        this.delegate = delegate;
    }

    @Override
    public ExternalResourceReadResponse openResource(URI location, boolean revalidate) {
        ExternalResourceReadResponse resource = this.delegate.openResource(location, revalidate);
        if (resource != null) {
            return new ProgressLoggingExternalResource(location, resource);
        }
        return null;
    }

    @Override
    @Nullable
    public ExternalResourceMetaData getMetaData(URI location, boolean revalidate) {
        return this.delegate.getMetaData(location, revalidate);
    }

    @VisibleForTesting
    public class ProgressLoggingExternalResource
    implements ExternalResourceReadResponse {
        private final ExternalResourceReadResponse resource;
        private final ResourceOperation downloadOperation;

        private ProgressLoggingExternalResource(URI location, ExternalResourceReadResponse resource) {
            this.resource = resource;
            this.downloadOperation = ProgressLoggingExternalResourceAccessor.this.createResourceOperation(location, ResourceOperation.Type.download, this.getClass(), resource.getMetaData().getContentLength());
        }

        @Override
        public InputStream openStream() throws IOException {
            return new AbstractProgressLoggingHandler.ProgressLoggingInputStream(this.resource.openStream(), this.downloadOperation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.resource.close();
            }
            finally {
                this.downloadOperation.completed();
            }
        }

        @Override
        public ExternalResourceMetaData getMetaData() {
            return this.resource.getMetaData();
        }

        public String toString() {
            return this.resource.toString();
        }
    }
}

