/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.impldep.com.google.common.collect.Interners;
import org.gradle.language.nativeplatform.internal.Expression;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.AbstractInclude;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.IncludeWithMacroFunctionCallExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.RegexBackedCSourceParser;

public class IncludeWithSimpleExpression
extends AbstractInclude {
    private static final Interner<IncludeWithSimpleExpression> INTERNER = Interners.newWeakInterner();
    private final String value;
    private final boolean isImport;
    private final IncludeType type;

    public static IncludeWithSimpleExpression create(String value, boolean isImport, IncludeType type) {
        return (IncludeWithSimpleExpression)INTERNER.intern((Object)new IncludeWithSimpleExpression(value, isImport, type));
    }

    public static Include create(Expression expression, boolean isImport) {
        if (expression.getType() == IncludeType.MACRO_FUNCTION && !expression.getArguments().isEmpty()) {
            return new IncludeWithMacroFunctionCallExpression(expression.getValue(), isImport, (ImmutableList<Expression>)ImmutableList.copyOf(expression.getArguments()));
        }
        return IncludeWithSimpleExpression.create(expression.getValue(), isImport, expression.getType());
    }

    public IncludeWithSimpleExpression(String value, boolean isImport, IncludeType type) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.value = value;
        this.isImport = isImport;
        this.type = type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isImport() {
        return this.isImport;
    }

    @Override
    public IncludeType getType() {
        return this.type;
    }

    public static Include parse(String value, boolean isImport) {
        Expression expression = RegexBackedCSourceParser.parseExpression(value);
        return IncludeWithSimpleExpression.create(expression.getValue(), isImport, expression.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncludeWithSimpleExpression that = (IncludeWithSimpleExpression)o;
        if (this.isImport != that.isImport) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + (this.isImport ? 1 : 0);
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

