/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.plugins;

import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.PublishableComponent;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MutableMavenProjectIdentity;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.Cast;
import org.gradle.language.ComponentWithBinaries;
import org.gradle.language.ComponentWithOutputs;
import org.gradle.language.ProductionComponent;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithExecutable;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithLinkUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithRuntimeUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithSharedLibrary;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithStaticLibrary;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.PublicationAwareComponent;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.CreateStaticLibrary;
import org.gradle.nativeplatform.tasks.ExtractSymbols;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.tasks.StripSymbols;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public class NativeBasePlugin
implements Plugin<ProjectInternal> {
    @Override
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        TaskContainerInternal tasks = project.getTasks();
        ProviderFactory providers = project.getProviders();
        DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        SoftwareComponentContainer components = project.getComponents();
        this.addLifecycleTasks(tasks, components);
        this.addTasksForComponentWithExecutable(tasks, providers, buildDirectory, components);
        this.addTasksForComponentWithSharedLibrary(tasks, providers, buildDirectory, components);
        this.addTasksForComponentWithStaticLibrary(tasks, providers, buildDirectory, components);
        ConfigurationContainer configurations = project.getConfigurations();
        project.getDependencies().getAttributesSchema().attribute(CppBinary.LINKAGE_ATTRIBUTE).getDisambiguationRules().add(LinkageSelectionRule.class);
        this.addOutgoingConfigurationForLinkUsage(components, configurations);
        this.addOutgoingConfigurationForRuntimeUsage(components, configurations);
        this.addPublicationsFromVariants(project, components);
    }

    private void addLifecycleTasks(final TaskContainer tasks, final SoftwareComponentContainer components) {
        components.withType(ComponentWithBinaries.class, new Action<ComponentWithBinaries>(){

            @Override
            public void execute(final ComponentWithBinaries component) {
                component.getBinaries().whenElementKnown((Action<? extends SoftwareComponent>)new Action<SoftwareComponent>(){

                    @Override
                    public void execute(SoftwareComponent binary) {
                        components.add(binary);
                    }
                });
                if (component instanceof ProductionComponent) {
                    component.getBinaries().whenElementFinalized(ComponentWithOutputs.class, new Action<ComponentWithOutputs>(){

                        @Override
                        public void execute(ComponentWithOutputs binary) {
                            FileCollection outputs = binary.getOutputs();
                            Names names = ((ComponentWithNames)((Object)binary)).getNames();
                            Task lifecycleTask = tasks.create(names.getTaskName("assemble"));
                            lifecycleTask.dependsOn(outputs);
                            if (binary == ((ProductionComponent)((Object)component)).getDevelopmentBinary().get()) {
                                tasks.getByName("assemble").dependsOn(outputs);
                            }
                        }
                    });
                }
            }
        });
    }

    private void addTasksForComponentWithExecutable(final TaskContainer tasks, final ProviderFactory providers, final DirectoryProperty buildDirectory, SoftwareComponentContainer components) {
        components.withType(ConfigurableComponentWithExecutable.class, new Action<ConfigurableComponentWithExecutable>(){

            @Override
            public void execute(final ConfigurableComponentWithExecutable executable) {
                final Names names = executable.getNames();
                NativeToolChain toolChain = executable.getToolChain();
                NativePlatform targetPlatform = executable.getTargetPlatform();
                LinkExecutable link = tasks.create(names.getTaskName("link"), LinkExecutable.class);
                link.source(executable.getObjects());
                link.lib(executable.getLinkLibraries());
                final PlatformToolProvider toolProvider = executable.getPlatformToolProvider();
                link.getLinkedFile().set(buildDirectory.file(providers.provider(new Callable<String>(){

                    @Override
                    public String call() {
                        return toolProvider.getExecutableName("exe/" + names.getDirName() + executable.getBaseName().get());
                    }
                })));
                link.getTargetPlatform().set(targetPlatform);
                link.getToolChain().set(toolChain);
                link.getDebuggable().set(executable.isDebuggable());
                executable.getLinkTask().set(link);
                executable.getDebuggerExecutableFile().set(link.getLinkedFile());
                if (executable.isDebuggable() && executable.isOptimized() && toolProvider.requiresDebugBinaryStripping()) {
                    Provider<RegularFile> symbolLocation = buildDirectory.file(providers.provider(new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getExecutableSymbolFileName("exe/" + names.getDirName() + "stripped/" + executable.getBaseName().get());
                        }
                    }));
                    Provider<RegularFile> strippedLocation = buildDirectory.file(providers.provider(new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getExecutableName("exe/" + names.getDirName() + "stripped/" + executable.getBaseName().get());
                        }
                    }));
                    StripSymbols stripSymbols = NativeBasePlugin.this.stripSymbols(link, names, tasks, toolChain, targetPlatform, strippedLocation);
                    executable.getExecutableFile().set(stripSymbols.getOutputFile());
                    ExtractSymbols extractSymbols = NativeBasePlugin.this.extractSymbols(link, names, tasks, toolChain, targetPlatform, symbolLocation);
                    executable.getOutputs().from(extractSymbols.getSymbolFile());
                } else {
                    executable.getExecutableFile().set(link.getLinkedFile());
                }
                InstallExecutable install = tasks.create(names.getTaskName("install"), InstallExecutable.class);
                install.getTargetPlatform().set(targetPlatform);
                install.getToolChain().set(toolChain);
                install.getInstallDirectory().set(buildDirectory.dir("install/" + names.getDirName()));
                install.getExecutableFile().set(executable.getExecutableFile());
                install.lib(executable.getRuntimeLibraries());
                executable.getInstallTask().set(install);
                executable.getInstallDirectory().set(install.getInstallDirectory());
                executable.getOutputs().from(executable.getInstallDirectory());
                executable.getDebuggerExecutableFile().set(install.getInstalledExecutable());
            }
        });
    }

    private void addTasksForComponentWithSharedLibrary(final TaskContainer tasks, final ProviderFactory providers, final DirectoryProperty buildDirectory, SoftwareComponentContainer components) {
        components.withType(ConfigurableComponentWithSharedLibrary.class, new Action<ConfigurableComponentWithSharedLibrary>(){

            @Override
            public void execute(final ConfigurableComponentWithSharedLibrary library) {
                final Names names = library.getNames();
                NativePlatform targetPlatform = library.getTargetPlatform();
                NativeToolChain toolChain = library.getToolChain();
                LinkSharedLibrary link = tasks.create(names.getTaskName("link"), LinkSharedLibrary.class);
                link.source(library.getObjects());
                link.lib(library.getLinkLibraries());
                final PlatformToolProvider toolProvider = library.getPlatformToolProvider();
                RegularFileProperty runtimeFile = buildDirectory.file(providers.provider(new Callable<String>(){

                    @Override
                    public String call() {
                        return toolProvider.getSharedLibraryName("lib/" + names.getDirName() + library.getBaseName().get());
                    }
                }));
                link.getLinkedFile().set(runtimeFile);
                link.getTargetPlatform().set(targetPlatform);
                link.getToolChain().set(toolChain);
                link.getDebuggable().set(library.isDebuggable());
                RegularFileProperty linkFile = link.getLinkedFile();
                runtimeFile = link.getLinkedFile();
                if (toolProvider.producesImportLibrary()) {
                    Provider<RegularFile> importLibrary = buildDirectory.file(providers.provider(new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getImportLibraryName("lib/" + names.getDirName() + library.getBaseName().get());
                        }
                    }));
                    link.getImportLibrary().set(importLibrary);
                    linkFile = link.getImportLibrary();
                }
                if (library.isDebuggable() && library.isOptimized() && toolProvider.requiresDebugBinaryStripping()) {
                    Provider<RegularFile> symbolLocation = buildDirectory.file(providers.provider(new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getLibrarySymbolFileName("lib/" + names.getDirName() + "stripped/" + library.getBaseName().get());
                        }
                    }));
                    Provider<RegularFile> strippedLocation = buildDirectory.file(providers.provider(new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getSharedLibraryName("lib/" + names.getDirName() + "stripped/" + library.getBaseName().get());
                        }
                    }));
                    StripSymbols stripSymbols = NativeBasePlugin.this.stripSymbols(link, names, tasks, toolChain, targetPlatform, strippedLocation);
                    runtimeFile = stripSymbols.getOutputFile();
                    linkFile = stripSymbols.getOutputFile();
                    ExtractSymbols extractSymbols = NativeBasePlugin.this.extractSymbols(link, names, tasks, toolChain, targetPlatform, symbolLocation);
                    library.getOutputs().from(extractSymbols.getSymbolFile());
                }
                library.getLinkTask().set(link);
                library.getLinkFile().set(linkFile);
                library.getRuntimeFile().set(runtimeFile);
                library.getOutputs().from(library.getLinkFile());
                library.getOutputs().from(library.getRuntimeFile());
            }
        });
    }

    private void addTasksForComponentWithStaticLibrary(final TaskContainer tasks, final ProviderFactory providers, final DirectoryProperty buildDirectory, SoftwareComponentContainer components) {
        components.withType(ConfigurableComponentWithStaticLibrary.class, new Action<ConfigurableComponentWithStaticLibrary>(){

            @Override
            public void execute(final ConfigurableComponentWithStaticLibrary library) {
                final Names names = library.getNames();
                CreateStaticLibrary createTask = tasks.create(names.getTaskName("create"), CreateStaticLibrary.class);
                createTask.source(library.getObjects());
                final PlatformToolProvider toolProvider = library.getPlatformToolProvider();
                Provider<RegularFile> linktimeFile = buildDirectory.file(providers.provider(new Callable<String>(){

                    @Override
                    public String call() {
                        return toolProvider.getStaticLibraryName("lib/" + names.getDirName() + library.getBaseName().get());
                    }
                }));
                createTask.getOutputFile().set(linktimeFile);
                createTask.getTargetPlatform().set(library.getTargetPlatform());
                createTask.getToolChain().set(library.getToolChain());
                library.getLinkFile().set(createTask.getBinaryFile());
                library.getCreateTask().set(createTask);
                library.getOutputs().from(library.getLinkFile());
            }
        });
    }

    private void addOutgoingConfigurationForLinkUsage(SoftwareComponentContainer components, final ConfigurationContainer configurations) {
        components.withType(ConfigurableComponentWithLinkUsage.class, new Action<ConfigurableComponentWithLinkUsage>(){

            @Override
            public void execute(ConfigurableComponentWithLinkUsage component) {
                Names names = component.getNames();
                Configuration linkElements = (Configuration)configurations.create(names.withSuffix("linkElements"));
                linkElements.extendsFrom(component.getImplementationDependencies());
                linkElements.setCanBeResolved(false);
                AttributeContainer attributes = component.getLinkAttributes();
                NativeBasePlugin.this.copyAttributesTo(attributes, linkElements);
                linkElements.getOutgoing().artifact(component.getLinkFile());
                component.getLinkElements().set(linkElements);
            }
        });
    }

    private void addOutgoingConfigurationForRuntimeUsage(SoftwareComponentContainer components, final ConfigurationContainer configurations) {
        components.withType(ConfigurableComponentWithRuntimeUsage.class, new Action<ConfigurableComponentWithRuntimeUsage>(){

            @Override
            public void execute(ConfigurableComponentWithRuntimeUsage component) {
                Names names = component.getNames();
                Configuration runtimeElements = (Configuration)configurations.create(names.withSuffix("runtimeElements"));
                runtimeElements.extendsFrom(component.getImplementationDependencies());
                runtimeElements.setCanBeResolved(false);
                AttributeContainer attributes = component.getRuntimeAttributes();
                NativeBasePlugin.this.copyAttributesTo(attributes, runtimeElements);
                if (component.hasRuntimeFile()) {
                    runtimeElements.getOutgoing().artifact(component.getRuntimeFile());
                }
                component.getRuntimeElements().set(runtimeElements);
            }
        });
    }

    private void addPublicationsFromVariants(final ProjectInternal project, final SoftwareComponentContainer components) {
        project.getPluginManager().withPlugin("maven-publish", (Action<? super AppliedPlugin>)new Action<AppliedPlugin>(){

            @Override
            public void execute(AppliedPlugin appliedPlugin) {
                components.withType(PublicationAwareComponent.class, new Action<PublicationAwareComponent>(){

                    @Override
                    public void execute(final PublicationAwareComponent component) {
                        project.getExtensions().configure(PublishingExtension.class, new Action<PublishingExtension>(){

                            @Override
                            public void execute(final PublishingExtension publishing) {
                                final ComponentWithVariants mainVariant = component.getMainPublication();
                                publishing.getPublications().create("main", MavenPublication.class, new Action<MavenPublication>(){

                                    @Override
                                    public void execute(MavenPublication publication) {
                                        MavenPublicationInternal publicationInternal = (MavenPublicationInternal)publication;
                                        publicationInternal.getMavenProjectIdentity().getArtifactId().set(component.getBaseName());
                                        publicationInternal.from(mainVariant);
                                        publicationInternal.publishWithOriginalFileName();
                                    }
                                });
                                Set<? extends SoftwareComponent> variants = mainVariant.getVariants();
                                if (variants instanceof DomainObjectSet) {
                                    ((DomainObjectSet)variants).all(new Action<SoftwareComponent>(){

                                        @Override
                                        public void execute(SoftwareComponent child) {
                                            this.addPublicationFromVariant(child, publishing);
                                        }
                                    });
                                } else {
                                    for (SoftwareComponent softwareComponent : variants) {
                                        this.addPublicationFromVariant(softwareComponent, publishing);
                                    }
                                }
                            }

                            private void addPublicationFromVariant(final SoftwareComponent child, PublishingExtension publishing) {
                                if (child instanceof PublishableComponent) {
                                    publishing.getPublications().create(child.getName(), MavenPublication.class, new Action<MavenPublication>(){

                                        @Override
                                        public void execute(MavenPublication publication) {
                                            MavenPublicationInternal publicationInternal = (MavenPublicationInternal)publication;
                                            NativeBasePlugin.this.fillInCoordinates(project, publicationInternal, (PublishableComponent)child);
                                            publicationInternal.from(child);
                                            publicationInternal.publishWithOriginalFileName();
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private void fillInCoordinates(ProjectInternal project, MavenPublicationInternal publication, PublishableComponent publishableComponent) {
        final ModuleVersionIdentifier coordinates = publishableComponent.getCoordinates();
        MutableMavenProjectIdentity identity = publication.getMavenProjectIdentity();
        identity.getGroupId().set(project.provider(new Callable<String>(){

            @Override
            public String call() {
                return coordinates.getGroup();
            }
        }));
        identity.getArtifactId().set(project.provider(new Callable<String>(){

            @Override
            public String call() {
                return coordinates.getName();
            }
        }));
        identity.getVersion().set(project.provider(new Callable<String>(){

            @Override
            public String call() {
                return coordinates.getVersion();
            }
        }));
    }

    private void copyAttributesTo(AttributeContainer attributes, Configuration linkElements) {
        for (Attribute<?> attribute : attributes.keySet()) {
            Object value = attributes.getAttribute(attribute);
            linkElements.getAttributes().attribute((Attribute)Cast.uncheckedCast(attribute), value);
        }
    }

    private StripSymbols stripSymbols(AbstractLinkTask link, Names names, TaskContainer tasks, NativeToolChain toolChain, NativePlatform currentPlatform, Provider<RegularFile> strippedLocation) {
        StripSymbols stripSymbols = tasks.create(names.getTaskName("stripSymbols"), StripSymbols.class);
        stripSymbols.getBinaryFile().set(link.getLinkedFile());
        stripSymbols.getOutputFile().set(strippedLocation);
        stripSymbols.getTargetPlatform().set(currentPlatform);
        stripSymbols.getToolChain().set(toolChain);
        return stripSymbols;
    }

    private ExtractSymbols extractSymbols(AbstractLinkTask link, Names names, TaskContainer tasks, NativeToolChain toolChain, NativePlatform currentPlatform, Provider<RegularFile> symbolLocation) {
        ExtractSymbols extractSymbols = tasks.create(names.getTaskName("extractSymbols"), ExtractSymbols.class);
        extractSymbols.getBinaryFile().set(link.getLinkedFile());
        extractSymbols.getSymbolFile().set(symbolLocation);
        extractSymbols.getTargetPlatform().set(currentPlatform);
        extractSymbols.getToolChain().set(toolChain);
        return extractSymbols;
    }

    static class LinkageSelectionRule
    implements AttributeDisambiguationRule<Linkage> {
        LinkageSelectionRule() {
        }

        @Override
        public void execute(MultipleCandidatesDetails<Linkage> details) {
            if (details.getCandidateValues().contains(Linkage.SHARED)) {
                details.closestMatch(Linkage.SHARED);
            }
        }
    }
}

