/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import org.gradle.api.tasks.Optional;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypedNotationConverter;
import org.gradle.nativeplatform.NativeLibraryRequirement;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.internal.ProjectNativeLibraryRequirement;

class NativeDependencyNotationParser {
    NativeDependencyNotationParser() {
    }

    public static NotationParser<Object, NativeLibraryRequirement> parser() {
        return NotationParserBuilder.toType(NativeLibraryRequirement.class).converter(new LibraryConverter()).converter(new NativeLibraryRequirementMapNotationConverter()).toComposite();
    }

    private static class NativeLibraryRequirementMapNotationConverter
    extends MapNotationConverter<NativeLibraryRequirement> {
        private NativeLibraryRequirementMapNotationConverter() {
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Map with mandatory 'library' and optional 'project' and 'linkage' keys").example("[project: ':someProj', library: 'mylib', linkage: 'static']");
        }

        protected NativeLibraryRequirement parseMap(@MapKey(value="library") String libraryName, @Optional @MapKey(value="project") String projectPath, @Optional @MapKey(value="linkage") String linkage) {
            return new ProjectNativeLibraryRequirement(projectPath, libraryName, linkage);
        }
    }

    private static class LibraryConverter
    extends TypedNotationConverter<NativeLibrarySpec, NativeLibraryRequirement> {
        private LibraryConverter() {
            super(NativeLibrarySpec.class);
        }

        @Override
        protected NativeLibraryRequirement parseType(NativeLibrarySpec notation) {
            return notation.getShared();
        }
    }
}

