/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.nativeplatform.toolchain.internal.PCHUtils;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutor;

@Incubating
public class PrefixHeaderFileGenerateTask
extends DefaultTask {
    private String header;
    private File prefixHeaderFile;
    private final WorkerExecutor workerExecutor;

    @Inject
    public PrefixHeaderFileGenerateTask(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    @TaskAction
    void generatePrefixHeaderFile() {
        this.workerExecutor.submit(GeneratePrefixHeaderFile.class, (Action<? super WorkerConfiguration>)new Action<WorkerConfiguration>(){

            @Override
            public void execute(WorkerConfiguration config) {
                config.setIsolationMode(IsolationMode.NONE);
                config.setParams(PrefixHeaderFileGenerateTask.this.header, PrefixHeaderFileGenerateTask.this.prefixHeaderFile);
            }
        });
    }

    @Input
    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    @OutputFile
    public File getPrefixHeaderFile() {
        return this.prefixHeaderFile;
    }

    public void setPrefixHeaderFile(File prefixHeaderFile) {
        this.prefixHeaderFile = prefixHeaderFile;
    }

    private static class GeneratePrefixHeaderFile
    implements Runnable {
        private final String header;
        private final File prefixHeaderFile;

        @Inject
        public GeneratePrefixHeaderFile(String header, File prefixHeaderFile) {
            this.header = header;
            this.prefixHeaderFile = prefixHeaderFile;
        }

        @Override
        public void run() {
            PCHUtils.generatePrefixHeaderFile(Lists.newArrayList((Object[])new String[]{this.header}), this.prefixHeaderFile);
        }
    }
}

