/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cpp.plugins;

import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.internal.provider.LockableCollectionProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.tasks.UnexportMainSymbol;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestExecutable;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestSuite;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;
import org.gradle.util.CollectionUtils;

@Incubating
public class CppUnitTestPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;

    @Inject
    public CppUnitTestPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
    }

    @Override
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        final DefaultCppTestSuite testComponent = this.componentFactory.newInstance(CppTestSuite.class, DefaultCppTestSuite.class, "test");
        project.getExtensions().add(CppTestSuite.class, "unitTest", testComponent);
        project.getComponents().add(testComponent);
        testComponent.getBaseName().set(project.getName() + "Test");
        project.afterEvaluate((Action<? super Project>)new Action<Project>(){

            @Override
            public void execute(final Project project) {
                ((LockableCollectionProperty)((Object)testComponent.getOperatingSystems())).lockNow();
                Set operatingSystemFamilies = (Set)((AbstractProvider)((Object)testComponent.getOperatingSystems())).get();
                if (operatingSystemFamilies.isEmpty()) {
                    throw new IllegalArgumentException("An operating system needs to be specified for the unit test.");
                }
                boolean hasHostOperatingSystem = CollectionUtils.any(operatingSystemFamilies, new Spec<OperatingSystemFamily>(){

                    @Override
                    public boolean isSatisfiedBy(OperatingSystemFamily element) {
                        return DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(element.getName());
                    }
                });
                if (hasHostOperatingSystem) {
                    String operatingSystemSuffix = "";
                    OperatingSystemFamily operatingSystem = CppUnitTestPlugin.this.objectFactory.named(OperatingSystemFamily.class, DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName());
                    Usage runtimeUsage = CppUnitTestPlugin.this.objectFactory.named(Usage.class, "native-runtime");
                    Provider<String> group = project.provider(new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return project.getGroup().toString();
                        }
                    });
                    Provider<String> version = project.provider(new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return project.getVersion().toString();
                        }
                    });
                    AttributeContainerInternal attributesDebug = CppUnitTestPlugin.this.attributesFactory.mutable();
                    attributesDebug.attribute(Usage.USAGE_ATTRIBUTE, runtimeUsage);
                    attributesDebug.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, true);
                    attributesDebug.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, false);
                    NativeVariantIdentity debugVariant = new NativeVariantIdentity("debug" + operatingSystemSuffix, testComponent.getBaseName(), group, version, true, false, operatingSystem, null, new DefaultUsageContext("debug" + operatingSystemSuffix + "Runtime", runtimeUsage, attributesDebug));
                    ToolChainSelector.Result<CppPlatform> result = CppUnitTestPlugin.this.toolChainSelector.select(CppPlatform.class);
                    testComponent.addExecutable(debugVariant, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    final TaskContainer tasks = project.getTasks();
                    final ProductionCppComponent mainComponent = (ProductionCppComponent)project.getComponents().withType(ProductionCppComponent.class).findByName("main");
                    if (mainComponent != null) {
                        testComponent.getTestedComponent().set(mainComponent);
                    }
                    ((DefaultBinaryCollection)testComponent.getBinaries()).whenElementKnown(DefaultCppTestExecutable.class, new Action<DefaultCppTestExecutable>(){

                        @Override
                        public void execute(final DefaultCppTestExecutable executable) {
                            if (mainComponent != null) {
                                mainComponent.getBinaries().whenElementFinalized((Action<? extends CppBinary>)new Action<CppBinary>(){

                                    @Override
                                    public void execute(CppBinary testedBinary) {
                                        FileCollection testableObjects;
                                        if (testedBinary != mainComponent.getDevelopmentBinary().get()) {
                                            return;
                                        }
                                        executable.getImplementationDependencies().extendsFrom(((DefaultCppBinary)testedBinary).getImplementationDependencies());
                                        if (mainComponent instanceof CppApplication) {
                                            UnexportMainSymbol unexportMainSymbol = tasks.create("relocateMainForTest", UnexportMainSymbol.class);
                                            unexportMainSymbol.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("obj/main/for-test"));
                                            unexportMainSymbol.getObjects().from(testedBinary.getObjects());
                                            testableObjects = unexportMainSymbol.getRelocatedObjects();
                                        } else {
                                            testableObjects = testedBinary.getObjects();
                                        }
                                        Dependency linkDependency = project.getDependencies().create(testableObjects);
                                        executable.getLinkConfiguration().getDependencies().add(linkDependency);
                                    }
                                });
                            }
                            RunTestExecutable testTask = tasks.create(executable.getNames().getTaskName("run"), RunTestExecutable.class);
                            testTask.setGroup("verification");
                            testTask.setDescription("Executes C++ unit tests.");
                            InstallExecutable installTask = (InstallExecutable)executable.getInstallTask().get();
                            testTask.onlyIf((Spec<? super Task>)new Spec<Task>(){

                                @Override
                                public boolean isSatisfiedBy(Task element) {
                                    return ((Directory)executable.getInstallDirectory().get()).getAsFile().exists();
                                }
                            });
                            testTask.getInputs().dir(executable.getInstallDirectory());
                            testTask.setExecutable(installTask.getRunScriptFile().get().getAsFile());
                            testTask.dependsOn(((CppTestExecutable)testComponent.getTestBinary().get()).getInstallDirectory());
                            testTask.setOutputDir(project.getLayout().getBuildDirectory().dir("test-results/" + executable.getNames().getDirName()).get().getAsFile());
                            executable.getRunTask().set(testTask);
                        }
                    });
                }
                ((DefaultBinaryCollection)testComponent.getBinaries()).realizeNow();
            }
        });
    }
}

