/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import groovy.util.Node;
import java.util.Arrays;
import java.util.List;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.base.Predicates;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.eclipse.model.WbDependentModule;
import org.gradle.plugins.ide.eclipse.model.WbModuleEntry;
import org.gradle.plugins.ide.eclipse.model.WbProperty;
import org.gradle.plugins.ide.eclipse.model.WbResource;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;

public class WtpComponent
extends XmlPersistableConfigurationObject {
    private String deployName;
    private String contextPath;
    private List<WbModuleEntry> wbModuleEntries = Lists.newArrayList();

    public WtpComponent(XmlTransformer xmlTransformer) {
        super(xmlTransformer);
    }

    @Override
    protected String getDefaultResourceName() {
        return "defaultWtpComponent.xml";
    }

    public String getDeployName() {
        return this.deployName;
    }

    public void setDeployName(String deployName) {
        this.deployName = deployName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public List<WbModuleEntry> getWbModuleEntries() {
        return this.wbModuleEntries;
    }

    public void setWbModuleEntries(List<WbModuleEntry> wbModuleEntries) {
        this.wbModuleEntries = wbModuleEntries;
    }

    public void configure(String deployName, String contextPath, List<WbModuleEntry> newEntries) {
        Iterable toKeep = Iterables.filter(this.wbModuleEntries, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(WbDependentModule.class)));
        this.wbModuleEntries = Lists.newArrayList((Iterable)Sets.newLinkedHashSet((Iterable)Iterables.concat((Iterable)toKeep, newEntries)));
        if (!Strings.isNullOrEmpty((String)deployName)) {
            this.deployName = deployName;
        }
        if (!Strings.isNullOrEmpty((String)contextPath)) {
            this.contextPath = contextPath;
        }
    }

    @Override
    protected void load(Node xml) {
        Node wbModuleNode = WtpComponent.getWbModuleNode(xml);
        this.deployName = (String)wbModuleNode.attribute((Object)"deploy-name");
        for (Node node : (List)Cast.uncheckedCast(wbModuleNode.children())) {
            if ("property".equals(node.name())) {
                if ("context-root".equals(node.attribute((Object)"name"))) {
                    this.contextPath = (String)node.attribute((Object)"value");
                    continue;
                }
                this.wbModuleEntries.add(new WbProperty(node));
                continue;
            }
            if ("wb-resource".equals(node.name())) {
                this.wbModuleEntries.add(new WbResource(node));
                continue;
            }
            if (!"dependent-module".equals(node.name())) continue;
            this.wbModuleEntries.add(new WbDependentModule(node));
        }
    }

    @Override
    protected void store(Node xml) {
        this.removeConfigurableDataFromXml();
        Node wbModuleNode = WtpComponent.getWbModuleNode(xml);
        wbModuleNode.attributes().put("deploy-name", this.deployName);
        if (!Strings.isNullOrEmpty((String)this.contextPath)) {
            new WbProperty("context-root", this.contextPath).appendNode(wbModuleNode);
        }
        for (WbModuleEntry wbModuleEntry : this.wbModuleEntries) {
            wbModuleEntry.appendNode(wbModuleNode);
        }
    }

    private void removeConfigurableDataFromXml() {
        Node wbModuleNode = WtpComponent.getWbModuleNode(this.getXml());
        for (String elementName : Arrays.asList("property", "wb-resource", "dependent-module")) {
            for (Node elementNode : XmlPersistableConfigurationObject.getChildren(wbModuleNode, elementName)) {
                wbModuleNode.remove(elementNode);
            }
        }
    }

    private static Node getWbModuleNode(Node xml) {
        Node wbModule = XmlPersistableConfigurationObject.findFirstChildNamed(xml, "wb-module");
        Preconditions.checkNotNull((Object)wbModule);
        return wbModule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        WtpComponent wtp = (WtpComponent)o;
        return Objects.equal((Object)this.deployName, (Object)wtp.deployName) && Objects.equal((Object)this.contextPath, (Object)wtp.contextPath) && Objects.equal(this.wbModuleEntries, wtp.wbModuleEntries);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.wbModuleEntries, this.deployName, this.contextPath});
    }

    public String toString() {
        return "WtpComponent{wbModuleEntries=" + this.wbModuleEntries + ", deployName='" + this.deployName + "'" + ", contextPath='" + this.contextPath + "'" + "}";
    }
}

