/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.scala.internal.reflect;

import java.lang.reflect.Field;
import org.gradle.internal.UncheckedException;

public class ScalaObject {
    private final Object instance;
    private final Class<?> type;
    private final String className;

    public ScalaObject(ClassLoader classLoader, String className) {
        this.className = className;
        Class<?> baseClass = this.getClass(classLoader, className);
        Field scalaObject = this.getModule(baseClass);
        this.instance = this.getInstance(scalaObject);
        this.type = scalaObject.getType();
    }

    private Object getInstance(Field scalaObject) {
        try {
            return scalaObject.get(null);
        }
        catch (IllegalAccessException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private Class<?> getClass(ClassLoader classLoader, String typeName) {
        try {
            return classLoader.loadClass(typeName + "$");
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private Field getModule(Class<?> baseClass) {
        try {
            return baseClass.getField("MODULE$");
        }
        catch (NoSuchFieldException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public Object getInstance() {
        return this.instance;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }
}

