/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaForkOptions;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;

@Incubating
public class JacocoPluginExtension {
    public static final String TASK_EXTENSION_NAME = "jacoco";
    private static final Logger LOGGER = Logging.getLogger(JacocoPluginExtension.class);
    protected final Project project;
    private final JacocoAgentJar agent;
    private String toolVersion;
    private final Property<File> reportsDir;

    public JacocoPluginExtension(Project project, JacocoAgentJar agent) {
        this.project = project;
        this.agent = agent;
        this.reportsDir = project.getObjects().property(File.class);
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public File getReportsDir() {
        return (File)this.reportsDir.get();
    }

    public void setReportsDir(Provider<File> reportsDir) {
        this.reportsDir.set(reportsDir);
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir.set(reportsDir);
    }

    public <T extends Task & JavaForkOptions> void applyTo(T task) {
        final String taskName = task.getName();
        LOGGER.debug("Applying Jacoco to " + taskName);
        final JacocoTaskExtension extension = task.getExtensions().create(TASK_EXTENSION_NAME, JacocoTaskExtension.class, this.project, this.agent, task);
        extension.setDestinationFile(this.project.provider(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return JacocoPluginExtension.this.project.file(String.valueOf(JacocoPluginExtension.this.project.getBuildDir()) + "/jacoco/" + taskName + ".exec");
            }
        }));
        ((JavaForkOptions)task).getJvmArgumentProviders().add(new JacocoAgent(extension));
        task.getOutputs().doNotCacheIf("JaCoCo configured to not produce its output as a file", (Spec<? super Task>)new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                return extension.isEnabled() && extension.getOutput() != JacocoTaskExtension.Output.FILE;
            }
        });
        task.getOutputs().doNotCacheIf("JaCoCo agent configured with `append = true`", (Spec<? super Task>)new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                return extension.isEnabled() && extension.isAppend();
            }
        });
    }

    public <T extends Task & JavaForkOptions> void applyTo(TaskCollection<T> tasks) {
        tasks.withType(JavaForkOptions.class, new Action<T>(){

            @Override
            public void execute(T task) {
                JacocoPluginExtension.this.applyTo(task);
            }
        });
    }

    private static class JacocoAgent
    implements CommandLineArgumentProvider,
    Named {
        private final JacocoTaskExtension jacoco;

        public JacocoAgent(JacocoTaskExtension jacoco) {
            this.jacoco = jacoco;
        }

        @Nullable
        @Optional
        @Nested
        public JacocoTaskExtension getJacoco() {
            return this.jacoco.isEnabled() ? this.jacoco : null;
        }

        @Override
        public Iterable<String> asArguments() {
            return this.jacoco.isEnabled() ? ImmutableList.of((Object)this.jacoco.getAsJvmArg()) : Collections.emptyList();
        }

        @Override
        public String getName() {
            return "jacocoAgent";
        }
    }
}

