/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.inconsistentResourceBundle;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentResourceBundleInspectionProvider;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.RemovePropertyLocalFix;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DuplicatedPropertiesInspectionProvider
implements InconsistentResourceBundleInspectionProvider {
    @Override
    @NotNull
    public String getName() {
        if ("REPORT_DUPLICATED_PROPERTIES" == null) {
            DuplicatedPropertiesInspectionProvider.$$$reportNull$$$0(0);
        }
        return "REPORT_DUPLICATED_PROPERTIES";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = InspectionsBundle.message((String)"inconsistent.bundle.report.duplicate.properties.values", (Object[])new Object[0]);
        if (string == null) {
            DuplicatedPropertiesInspectionProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void check(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<? extends PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, Map<PropertiesFile, Map<String, String>> propertiesFilesNamesMaps, InspectionManager manager, RefManager refManager, ProblemDescriptionsProcessor processor) {
        for (PropertiesFile propertiesFile : files) {
            PropertiesFile parent = (PropertiesFile)parents.get((Object)propertiesFile);
            if (parent == null) continue;
            Set<String> parentKeys = keysUpToParent.get(parent);
            THashSet overriddenKeys = new THashSet(propertiesFilesNamesMaps.get(propertiesFile).keySet());
            overriddenKeys.retainAll(parentKeys);
            for (String overriddenKey : overriddenKeys) {
                IProperty property = propertiesFile.findPropertyByKey(overriddenKey);
                assert (property != null);
                while (parent != null) {
                    IProperty parentProperty = parent.findPropertyByKey(overriddenKey);
                    if (parentProperty != null && Comparing.strEqual((String)property.getValue(), (String)parentProperty.getValue())) {
                        String message = InspectionsBundle.message((String)"inconsistent.bundle.property.inherited.with.the.same.value", (Object[])new Object[]{parent.getName()});
                        ProblemDescriptor descriptor = manager.createProblemDescriptor(property.getPsiElement(), message, (LocalQuickFix)RemovePropertyLocalFix.INSTANCE, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false);
                        processor.addProblemElement((RefEntity)refManager.getReference((PsiElement)propertiesFile.getContainingFile()), new CommonProblemDescriptor[]{descriptor});
                    }
                    parent = (PropertiesFile)parents.get((Object)parent);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/i18n/inconsistentResourceBundle/DuplicatedPropertiesInspectionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

