/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestType;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractTestNGPatternConfigurationProducer
extends AbstractPatternBasedConfigurationProducer<TestNGConfiguration> {
    protected AbstractTestNGPatternConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected boolean setupConfigurationFromContext(TestNGConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElement element = this.checkPatterns(context, classes);
        if (element == null) {
            return false;
        }
        sourceElement.set((Object)element);
        TestData data = configuration.getPersistantData();
        data.setPatterns(classes);
        data.TEST_OBJECT = TestType.PATTERN.getType();
        data.setScope(this.setupPackageConfiguration(context, (ModuleBasedConfiguration)configuration, data.getScope()));
        configuration.setGeneratedName();
        this.setupConfigurationParamName((JavaTestConfigurationBase)configuration, context.getLocation());
        return true;
    }

    protected Module findModule(TestNGConfiguration configuration, Module contextModule) {
        Set<String> patterns = configuration.data.getPatterns();
        return this.findModule((ModuleBasedConfiguration)configuration, contextModule, patterns);
    }

    public boolean isConfigurationFromContext(TestNGConfiguration testNGConfiguration, ConfigurationContext context) {
        if (!this.isApplicableTestType(testNGConfiguration.getTestType(), context)) {
            return false;
        }
        if (this.differentParamSet((JavaTestConfigurationBase)testNGConfiguration, context.getLocation())) {
            return false;
        }
        return this.isConfiguredFromContext(context, testNGConfiguration.getPersistantData().getPatterns());
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return TestType.PATTERN.getType().equals(type);
    }
}

