/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.uiDesigner.HSpacer;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.VSpacer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.FeedbackLayer;
import com.intellij.uiDesigner.designSurface.GridDropLocation;
import com.intellij.uiDesigner.designSurface.GridInsertLocation;
import com.intellij.uiDesigner.designSurface.GridInsertMode;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.InsertComponentProcessor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.radComponents.RadAbstractGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirstComponentInsertLocation
extends GridDropLocation {
    protected final Rectangle myCellRect;
    protected final int myXPart;
    protected final int myYPart;

    public FirstComponentInsertLocation(@NotNull RadContainer container, Point targetPoint, @NotNull Rectangle cellRect) {
        if (container == null) {
            FirstComponentInsertLocation.$$$reportNull$$$0(0);
        }
        if (cellRect == null) {
            FirstComponentInsertLocation.$$$reportNull$$$0(1);
        }
        super(container, 0, 0);
        this.myCellRect = cellRect;
        int midX1 = this.myCellRect.x + this.myCellRect.width / 3;
        int midX2 = this.myCellRect.x + this.myCellRect.width * 2 / 3;
        int midY1 = this.myCellRect.y + this.myCellRect.height / 3;
        int midY2 = this.myCellRect.y + this.myCellRect.height * 2 / 3;
        this.myXPart = targetPoint.x < midX1 ? 0 : (targetPoint.x < midX2 ? 1 : 2);
        this.myYPart = targetPoint.y < midY1 ? 0 : (targetPoint.y < midY2 ? 1 : 2);
    }

    public FirstComponentInsertLocation(@NotNull RadContainer container, Rectangle cellRect, int xPart, int yPart) {
        if (container == null) {
            FirstComponentInsertLocation.$$$reportNull$$$0(2);
        }
        super(container, 0, 0);
        this.myCellRect = cellRect;
        this.myXPart = xPart;
        this.myYPart = yPart;
    }

    @Override
    public void placeFeedback(FeedbackLayer feedbackLayer, ComponentDragObject dragObject) {
        int midX1 = this.myCellRect.x + this.myCellRect.width / 3;
        int midX2 = this.myCellRect.x + this.myCellRect.width * 2 / 3;
        int midY1 = this.myCellRect.y + this.myCellRect.height / 3;
        int midY2 = this.myCellRect.y + this.myCellRect.height * 2 / 3;
        Rectangle rc = new Rectangle();
        if (this.myXPart == 0) {
            rc.x = this.myCellRect.x;
            rc.width = this.initialWidth(dragObject, midX1 - this.myCellRect.x);
        } else if (this.myXPart == 1) {
            rc.x = this.myCellRect.x;
            rc.width = this.myCellRect.width;
        } else {
            rc.width = this.initialWidth(dragObject, this.myCellRect.width - (midX2 - this.myCellRect.x));
            rc.x = this.myCellRect.width - rc.width;
        }
        if (this.myYPart == 0) {
            rc.y = this.myCellRect.y;
            rc.height = this.initialHeight(dragObject, midY1 - this.myCellRect.y);
        } else if (this.myYPart == 1) {
            rc.y = this.myCellRect.y;
            rc.height = this.myCellRect.height;
        } else {
            rc.height = this.initialHeight(dragObject, this.myCellRect.height - (midY2 - this.myCellRect.y));
            rc.y = this.myCellRect.height - rc.height;
        }
        feedbackLayer.putFeedback(this.myContainer.getDelegee(), rc, this.getInsertFeedbackTooltip());
    }

    private String getInsertFeedbackTooltip() {
        StringBuilder result = new StringBuilder(this.myContainer.getDisplayName());
        result.append(" (");
        if (this.myXPart == 1 && this.myYPart == 1) {
            result.append(UIDesignerBundle.message("insert.feedback.fill", new Object[0]));
        } else {
            if (this.myYPart == 0) {
                result.append(UIDesignerBundle.message("insert.feedback.top", new Object[0]));
            } else if (this.myYPart == 2) {
                result.append(UIDesignerBundle.message("insert.feedback.bottom", new Object[0]));
            }
            if (this.myYPart != 1 && this.myXPart != 1) {
                result.append(" ");
            }
            if (this.myXPart == 0) {
                result.append(UIDesignerBundle.message("insert.feedback.left", new Object[0]));
            } else if (this.myXPart == 2) {
                result.append(UIDesignerBundle.message("insert.feedback.right", new Object[0]));
            }
        }
        result.append(")");
        return result.toString();
    }

    private int initialWidth(ComponentDragObject dragObject, int defaultSize) {
        Dimension initialSize = dragObject.getInitialSize(this.getContainer());
        if (initialSize.width > 0 && initialSize.width < defaultSize) {
            return initialSize.width;
        }
        return defaultSize;
    }

    private int initialHeight(ComponentDragObject dragObject, int defaultSize) {
        Dimension initialSize = dragObject.getInitialSize(this.getContainer());
        if (initialSize.height > 0 && initialSize.height < defaultSize) {
            return initialSize.height;
        }
        return defaultSize;
    }

    @Override
    public boolean canDrop(ComponentDragObject dragObject) {
        if (dragObject.getComponentCount() == 1 && (this.myContainer.getGridRowCount() == 0 || this.myContainer.getGridColumnCount() == 0)) {
            return true;
        }
        return super.canDrop(dragObject);
    }

    @Override
    public void processDrop(GuiEditor editor, RadComponent[] components, GridConstraints[] constraintsToAdjust, ComponentDragObject dragObject) {
        RadAbstractGridLayoutManager gridLayout = this.myContainer.getGridLayoutManager();
        if (this.myContainer.getGridRowCount() == 0 && this.myContainer.getGridColumnCount() == 0) {
            gridLayout.insertGridCells(this.myContainer, 0, false, true, true);
            gridLayout.insertGridCells(this.myContainer, 0, true, true, true);
        }
        super.processDrop(editor, components, constraintsToAdjust, dragObject);
        Palette palette = Palette.getInstance(editor.getProject());
        ComponentItem hSpacerItem = palette.getItem(HSpacer.class.getName());
        ComponentItem vSpacerItem = palette.getItem(VSpacer.class.getName());
        InsertComponentProcessor icp = new InsertComponentProcessor(editor);
        if (this.myXPart == 0) {
            this.insertSpacer(icp, hSpacerItem, GridInsertMode.ColumnAfter);
        }
        if (this.myXPart == 2) {
            this.insertSpacer(icp, hSpacerItem, GridInsertMode.ColumnBefore);
        }
        if (this.myYPart == 0) {
            this.insertSpacer(icp, vSpacerItem, GridInsertMode.RowAfter);
        }
        if (this.myYPart == 2) {
            this.insertSpacer(icp, vSpacerItem, GridInsertMode.RowBefore);
        }
    }

    @Override
    @Nullable
    public ComponentDropLocation getAdjacentLocation(ComponentDropLocation.Direction direction) {
        if (direction == ComponentDropLocation.Direction.DOWN && this.myYPart < 2) {
            return this.createAdjacentLocation(this.myXPart, this.myYPart + 1);
        }
        if (direction == ComponentDropLocation.Direction.UP && this.myYPart > 0) {
            return this.createAdjacentLocation(this.myXPart, this.myYPart - 1);
        }
        if (direction == ComponentDropLocation.Direction.RIGHT && this.myXPart < 2) {
            return this.createAdjacentLocation(this.myXPart + 1, this.myYPart);
        }
        if (direction == ComponentDropLocation.Direction.LEFT && this.myXPart > 0) {
            return this.createAdjacentLocation(this.myXPart - 1, this.myYPart);
        }
        return null;
    }

    protected FirstComponentInsertLocation createAdjacentLocation(int xPart, int yPart) {
        return new FirstComponentInsertLocation(this.myContainer, this.myCellRect, xPart, yPart);
    }

    private void insertSpacer(InsertComponentProcessor icp, ComponentItem spacerItem, GridInsertMode mode) {
        GridInsertLocation location = new GridInsertLocation(this.myContainer, 0, 0, mode);
        icp.processComponentInsert(spacerItem, location);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "container";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "cellRect";
                break;
            }
        }
        objectArray[1] = "com/intellij/uiDesigner/designSurface/FirstComponentInsertLocation";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

