/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightFillLayout;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.highlighter.XmlFileHighlighter;
import com.intellij.ide.palette.impl.PaletteToolWindowManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.uiDesigner.CutCopyPasteSupport;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.HierarchyChangeListener;
import com.intellij.uiDesigner.LoaderFactory;
import com.intellij.uiDesigner.ModuleProvider;
import com.intellij.uiDesigner.SelectionState;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.XmlReader;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.componentTree.ComponentPtr;
import com.intellij.uiDesigner.componentTree.ComponentSelectionListener;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Util;
import com.intellij.uiDesigner.designSurface.ActiveDecorationLayer;
import com.intellij.uiDesigner.designSurface.DesignDropTargetListener;
import com.intellij.uiDesigner.designSurface.DragLayer;
import com.intellij.uiDesigner.designSurface.GlassLayer;
import com.intellij.uiDesigner.designSurface.GridCaptionPanel;
import com.intellij.uiDesigner.designSurface.InplaceEditingLayer;
import com.intellij.uiDesigner.designSurface.MainProcessor;
import com.intellij.uiDesigner.designSurface.PassiveDecorationLayer;
import com.intellij.uiDesigner.designSurface.QuickFixManagerImpl;
import com.intellij.uiDesigner.editor.UIFormEditor;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindow;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindowManager;
import com.intellij.uiDesigner.propertyInspector.PropertyInspector;
import com.intellij.uiDesigner.propertyInspector.properties.IntroStringProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.uiDesigner.radComponents.RadTabbedPane;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GuiEditor
extends JPanel
implements DesignerEditorPanelFacade,
DataProvider,
ModuleProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.GuiEditor");
    private final Project myProject;
    @NotNull
    private final UIFormEditor myEditor;
    private Module myModule;
    @NotNull
    private final VirtualFile myFile;
    private Exception myWhere;
    private static final Integer LAYER_COMPONENT = JLayeredPane.DEFAULT_LAYER;
    private static final Integer LAYER_PASSIVE_DECORATION = JLayeredPane.POPUP_LAYER;
    private static final Integer LAYER_DND = JLayeredPane.DRAG_LAYER;
    private static final Integer LAYER_GLASS = new Integer(JLayeredPane.DRAG_LAYER + 100);
    private static final Integer LAYER_ACTIVE_DECORATION = new Integer(LAYER_GLASS + 100);
    private static final Integer LAYER_INPLACE_EDITING = new Integer(LAYER_ACTIVE_DECORATION + 100);
    private final EventListenerList myListenerList;
    private final Document myDocument;
    final MainProcessor myProcessor;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final MyLayeredPane myLayeredPane;
    private final PassiveDecorationLayer myDecorationLayer;
    private final DragLayer myDragLayer;
    private final InplaceEditingLayer myInplaceEditingLayer;
    private final MyDeleteProvider myDeleteProvider;
    private final MyPsiTreeChangeListener myPsiTreeChangeListener;
    private RadRootContainer myRootContainer;
    private boolean myInsideChange;
    private final DocumentListener myDocumentListener;
    private final CardLayout myCardLayout;
    private final ThreeComponentsSplitter myContentSplitter;
    private final JPanel myCardPanel;
    @NonNls
    private static final String CARD_VALID = "valid";
    @NonNls
    private static final String CARD_INVALID = "invalid";
    private final JPanel myValidCard;
    private final JPanel myInvalidCard;
    private boolean myInvalid;
    private final CutCopyPasteSupport myCutCopyPasteSupport;
    private final SelectionState mySelectionState;
    @NotNull
    private final GlassLayer myGlassLayer;
    private final ActiveDecorationLayer myActiveDecorationLayer;
    private boolean myShowGrid;
    private boolean myShowComponentTags;
    private final DesignDropTargetListener myDropTargetListener;
    private JLabel myFormInvalidLabel;
    private final QuickFixManagerImpl myQuickFixManager;
    private final GridCaptionPanel myHorzCaptionPanel;
    private final GridCaptionPanel myVertCaptionPanel;
    private ComponentPtr mySelectionAnchor;
    private ComponentPtr mySelectionLead;
    private Object myNextSaveGroupId;
    @NonNls
    private static final String ourHelpID = "guiDesigner.uiTour.workspace";
    public static final DataKey<GuiEditor> DATA_KEY = DataKey.create((String)GuiEditor.class.getName());

    public GuiEditor(@NotNull UIFormEditor editor, @NotNull Project project, @NotNull Module module, @NotNull VirtualFile file) {
        if (editor == null) {
            GuiEditor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GuiEditor.$$$reportNull$$$0(1);
        }
        if (module == null) {
            GuiEditor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            GuiEditor.$$$reportNull$$$0(3);
        }
        this.myCardLayout = new CardLayout();
        this.myContentSplitter = new ThreeComponentsSplitter();
        this.myCardPanel = new JPanel(this.myCardLayout);
        this.myShowGrid = true;
        this.myShowComponentTags = true;
        this.myNextSaveGroupId = new Object();
        this.myEditor = editor;
        LOG.assertTrue(file.isValid());
        this.myProject = project;
        this.myModule = module;
        this.myFile = file;
        this.myCutCopyPasteSupport = new CutCopyPasteSupport(this);
        this.setLayout(new BorderLayout());
        this.myContentSplitter.setDividerWidth(0);
        this.myContentSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.add((Component)this.myContentSplitter, "Center");
        this.myValidCard = new JPanel(new BorderLayout());
        this.myInvalidCard = this.createInvalidCard();
        this.myCardPanel.add((Component)this.myValidCard, CARD_VALID);
        this.myCardPanel.add((Component)this.myInvalidCard, CARD_INVALID);
        JPanel contentPanel = new JPanel((LayoutManager)new LightFillLayout());
        JLabel toolbar = new JLabel();
        toolbar.setVisible(false);
        contentPanel.add(toolbar);
        contentPanel.add(this.myCardPanel);
        this.myContentSplitter.setInnerComponent((JComponent)contentPanel);
        this.myListenerList = new EventListenerList();
        this.myDecorationLayer = new PassiveDecorationLayer(this);
        this.myDragLayer = new DragLayer(this);
        this.myLayeredPane = new MyLayeredPane();
        this.myInplaceEditingLayer = new InplaceEditingLayer(this);
        this.myLayeredPane.add(this.myInplaceEditingLayer, LAYER_INPLACE_EDITING);
        this.myActiveDecorationLayer = new ActiveDecorationLayer(this);
        this.myLayeredPane.add(this.myActiveDecorationLayer, LAYER_ACTIVE_DECORATION);
        this.myGlassLayer = new GlassLayer(this);
        this.myLayeredPane.add(this.myGlassLayer, LAYER_GLASS);
        this.myLayeredPane.add(this.myDecorationLayer, LAYER_PASSIVE_DECORATION);
        this.myLayeredPane.add(this.myDragLayer, LAYER_DND);
        this.myGlassLayer.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GuiEditor.this.myDecorationLayer.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                GuiEditor.this.myDecorationLayer.repaint();
            }
        });
        this.mySelectionState = new SelectionState(this);
        this.myDeleteProvider = new MyDeleteProvider();
        final Alarm alarm = new Alarm();
        this.myDocumentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!GuiEditor.this.myInsideChange) {
                    UndoManager undoManager = UndoManager.getInstance((Project)GuiEditor.this.getProject());
                    alarm.cancelAllRequests();
                    alarm.addRequest((Runnable)new MySynchronizeRequest(undoManager.isUndoInProgress() || undoManager.isRedoInProgress()), 100, ModalityState.stateForComponent((Component)GuiEditor.this));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uiDesigner/designSurface/GuiEditor$2", "documentChanged"));
            }
        };
        this.myDocument = FileDocumentManager.getInstance().getDocument(file);
        this.myDocument.addDocumentListener(this.myDocumentListener);
        this.readFromFile(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground((Color)GridCaptionPanel.getGutterColor());
        this.myHorzCaptionPanel = new GridCaptionPanel(this, false);
        this.myVertCaptionPanel = new GridCaptionPanel(this, true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        panel.add((Component)this.myVertCaptionPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        panel.add((Component)this.myHorzCaptionPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myLayeredPane));
        this.myScrollPane.setBackground((Color)new JBColor(() -> EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()));
        panel.add((Component)this.myScrollPane, gbc);
        this.myHorzCaptionPanel.attachToScrollPane(this.myScrollPane);
        this.myVertCaptionPanel.attachToScrollPane(this.myScrollPane);
        this.myValidCard.add((Component)panel, "Center");
        CancelCurrentOperationAction cancelCurrentOperationAction = new CancelCurrentOperationAction();
        cancelCurrentOperationAction.registerCustomShortcutSet(CommonShortcuts.ESCAPE, this);
        this.myProcessor = new MainProcessor(this);
        this.myPsiTreeChangeListener = new MyPsiTreeChangeListener();
        PsiManager.getInstance((Project)this.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        this.myQuickFixManager = new QuickFixManagerImpl(this, this.myGlassLayer, this.myScrollPane.getViewport());
        this.myDropTargetListener = new DesignDropTargetListener(this);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            new DropTarget(this.getGlassLayer(), 3, this.myDropTargetListener);
        }
        this.myActiveDecorationLayer.installSelectionWatcher();
        EmptyAction.registerWithShortcutSet((String)"GuiDesigner.IncreaseIndent", (ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 0)), (JComponent)this.myGlassLayer);
        EmptyAction.registerWithShortcutSet((String)"GuiDesigner.DecreaseIndent", (ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 1)), (JComponent)this.myGlassLayer);
        UIUtil.invokeLaterIfNeeded(() -> {
            DesignerToolWindowManager.getInstance(this.myProject).bind(this);
            PaletteToolWindowManager.getInstance(this.myProject).bind(this);
        });
    }

    public ThreeComponentsSplitter getContentSplitter() {
        return this.myContentSplitter;
    }

    @NotNull
    public UIFormEditor getEditor() {
        UIFormEditor uIFormEditor = this.myEditor;
        if (uIFormEditor == null) {
            GuiEditor.$$$reportNull$$$0(4);
        }
        return uIFormEditor;
    }

    @NotNull
    public SelectionState getSelectionState() {
        SelectionState selectionState = this.mySelectionState;
        if (selectionState == null) {
            GuiEditor.$$$reportNull$$$0(5);
        }
        return selectionState;
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myWhere != null) {
            LOG.error("Already disposed: old trace: ", (Throwable)this.myWhere);
            LOG.error("Already disposed: new trace: ");
        } else {
            this.myWhere = new Exception();
        }
        this.myDocument.removeDocumentListener(this.myDocumentListener);
        PsiManager.getInstance((Project)this.getProject()).removePsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        DesignerToolWindowManager.getInstance(this.myProject).dispose(this);
        PaletteToolWindowManager.getInstance(this.myProject).dispose(this);
        this.myPsiTreeChangeListener.dispose();
        Disposer.dispose((Disposable)this.myContentSplitter);
    }

    @Override
    @NotNull
    public Module getModule() {
        if (this.myModule.isDisposed()) {
            this.myModule = ModuleUtilCore.findModuleForFile((VirtualFile)this.myFile, (Project)this.myProject);
            if (this.myModule == null) {
                throw new IllegalArgumentException("No module for file " + this.myFile);
            }
        }
        Module module = this.myModule;
        if (module == null) {
            GuiEditor.$$$reportNull$$$0(6);
        }
        return module;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GuiEditor.$$$reportNull$$$0(7);
        }
        return project;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            GuiEditor.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    public PsiFile getPsiFile() {
        return PsiManager.getInstance((Project)this.getProject()).findFile(this.myFile);
    }

    public boolean isEditable() {
        Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
        return document != null && document.isWritable();
    }

    public boolean ensureEditable() {
        PsiClass psiClass;
        String classToBind;
        if (this.isEditable()) {
            return true;
        }
        VirtualFile sourceFileToCheckOut = null;
        if (!GuiDesignerConfiguration.getInstance((Project)this.getProject()).INSTRUMENT_CLASSES && (classToBind = this.myRootContainer.getClassToBind()) != null && !classToBind.isEmpty() && (psiClass = FormEditingUtil.findClassToBind(this.getModule(), classToBind)) != null) {
            sourceFileToCheckOut = psiClass.getContainingFile().getVirtualFile();
        }
        ReadonlyStatusHandler.OperationStatus status = sourceFileToCheckOut != null ? ReadonlyStatusHandler.getInstance((Project)this.getProject()).ensureFilesWritable(new VirtualFile[]{this.myFile, sourceFileToCheckOut}) : ReadonlyStatusHandler.getInstance((Project)this.getProject()).ensureFilesWritable(new VirtualFile[]{this.myFile});
        return !status.hasReadonlyFiles();
    }

    public void refresh() {
        GuiEditor.refreshImpl(this.myRootContainer);
        this.myRootContainer.getDelegee().revalidate();
        this.repaintLayeredPane();
    }

    public void refreshAndSave(boolean forceSync) {
        DesignerToolWindow toolWindow = DesignerToolWindowManager.getInstance(this);
        if (toolWindow == null) {
            return;
        }
        PropertyInspector propertyInspector = toolWindow.getPropertyInspector();
        if (propertyInspector != null) {
            propertyInspector.synchWithTree(forceSync);
        }
        this.refresh();
        this.saveToFile();
        this.myHorzCaptionPanel.repaint();
        this.myVertCaptionPanel.repaint();
    }

    public Object getNextSaveGroupId() {
        return this.myNextSaveGroupId;
    }

    private static void refreshImpl(RadComponent component) {
        if (component.getParent() != null) {
            Dimension size = component.getSize();
            int oldWidth = size.width;
            int oldHeight = size.height;
            Util.adjustSize((Component)component.getDelegee(), (GridConstraints)component.getConstraints(), (Dimension)size);
            if (oldWidth != size.width || oldHeight != size.height) {
                if (component.getParent().isXY()) {
                    component.setSize(size);
                }
                component.getDelegee().invalidate();
            }
        }
        if (component instanceof RadContainer) {
            component.refresh();
            RadContainer container = (RadContainer)component;
            for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                GuiEditor.refreshImpl(container.getComponent(i));
            }
        }
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            GuiEditor.$$$reportNull$$$0(9);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return ourHelpID;
        }
        Project project = this.getProject();
        if (project.isDisposed()) {
            return null;
        }
        DesignerToolWindow toolWindow = DesignerToolWindowManager.getInstance(this);
        if (toolWindow == null) {
            return null;
        }
        PropertyInspector inspector = toolWindow.getPropertyInspector();
        if (inspector != null && inspector.isEditing()) {
            return null;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myDeleteProvider;
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCutCopyPasteSupport;
        }
        return null;
    }

    private JPanel createInvalidCard() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myFormInvalidLabel = new JLabel(UIDesignerBundle.message("error.form.file.is.invalid", new Object[0]));
        panel.add((Component)this.myFormInvalidLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public DragLayer getDragLayer() {
        return this.myDragLayer;
    }

    @NotNull
    public RadRootContainer getRootContainer() {
        RadRootContainer radRootContainer = this.myRootContainer;
        if (radRootContainer == null) {
            GuiEditor.$$$reportNull$$$0(10);
        }
        return radRootContainer;
    }

    public void fireSelectedComponentChanged() {
        ComponentSelectionListener[] listeners;
        for (ComponentSelectionListener listener : listeners = (ComponentSelectionListener[])this.myListenerList.getListeners(ComponentSelectionListener.class)) {
            listener.selectedComponentChanged(this);
        }
    }

    private void fireHierarchyChanged() {
        HierarchyChangeListener[] listeners;
        for (HierarchyChangeListener listener : listeners = (HierarchyChangeListener[])this.myListenerList.getListeners(HierarchyChangeListener.class)) {
            listener.hierarchyChanged();
        }
    }

    @NotNull
    public GlassLayer getGlassLayer() {
        GlassLayer glassLayer = this.myGlassLayer;
        if (glassLayer == null) {
            GuiEditor.$$$reportNull$$$0(11);
        }
        return glassLayer;
    }

    public InplaceEditingLayer getInplaceEditingLayer() {
        return this.myInplaceEditingLayer;
    }

    @NotNull
    public JLayeredPane getLayeredPane() {
        MyLayeredPane myLayeredPane = this.myLayeredPane;
        if (myLayeredPane == null) {
            GuiEditor.$$$reportNull$$$0(12);
        }
        return myLayeredPane;
    }

    public void repaintLayeredPane() {
        this.myLayeredPane.repaint();
    }

    public void addComponentSelectionListener(ComponentSelectionListener l) {
        this.myListenerList.add(ComponentSelectionListener.class, l);
    }

    public void removeComponentSelectionListener(ComponentSelectionListener l) {
        this.myListenerList.remove(ComponentSelectionListener.class, l);
    }

    public void addHierarchyChangeListener(@NotNull HierarchyChangeListener l) {
        if (l == null) {
            GuiEditor.$$$reportNull$$$0(13);
        }
        this.myListenerList.add(HierarchyChangeListener.class, l);
    }

    public void removeHierarchyChangeListener(@NotNull HierarchyChangeListener l) {
        if (l == null) {
            GuiEditor.$$$reportNull$$$0(14);
        }
        this.myListenerList.remove(HierarchyChangeListener.class, l);
    }

    private void saveToFile() {
        LOG.debug("GuiEditor.saveToFile(): group ID=" + this.myNextSaveGroupId);
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            block6: {
                this.myInsideChange = true;
                try {
                    XmlWriter writer = new XmlWriter();
                    this.getRootContainer().write(writer);
                    String newText = writer.getText();
                    String oldText = this.myDocument.getText();
                    try {
                        ReplaceInfo replaceInfo = GuiEditor.findFragmentToChange(oldText, newText);
                        if (replaceInfo.getStartOffset() == -1) {
                            break block6;
                        }
                        this.myDocument.replaceString(replaceInfo.getStartOffset(), replaceInfo.getEndOffset(), (CharSequence)replaceInfo.getReplacement());
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                        this.myDocument.replaceString(0, oldText.length(), (CharSequence)newText);
                    }
                }
                finally {
                    this.myInsideChange = false;
                }
            }
        }), "UI Designer Save", this.myNextSaveGroupId);
        this.myNextSaveGroupId = new Object();
        this.fireHierarchyChanged();
    }

    public ActiveDecorationLayer getActiveDecorationLayer() {
        return this.myActiveDecorationLayer;
    }

    public void setStringDescriptorLocale(Locale locale) {
        this.myRootContainer.setStringDescriptorLocale(locale);
        this.refreshProperties();
        DesignerToolWindowManager.getInstance(this).updateComponentTree();
        DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
    }

    @Nullable
    public Locale getStringDescriptorLocale() {
        return this.myRootContainer.getStringDescriptorLocale();
    }

    private void refreshProperties() {
        Ref anythingModified = new Ref();
        FormEditingUtil.iterate(this.myRootContainer, component -> {
            RadComponent radComponent = (RadComponent)component;
            boolean componentModified = false;
            for (IProperty prop : component.getModifiedProperties()) {
                if (!(prop instanceof IntroStringProperty)) continue;
                IntroStringProperty strProp = (IntroStringProperty)prop;
                componentModified = strProp.refreshValue(radComponent) || componentModified;
            }
            if (component instanceof RadContainer) {
                boolean bl = componentModified = ((RadContainer)component).updateBorder() || componentModified;
            }
            if (component.getParentContainer() instanceof RadTabbedPane) {
                boolean bl = componentModified = ((RadTabbedPane)component.getParentContainer()).refreshChildTitle(radComponent) || componentModified;
            }
            if (componentModified) {
                anythingModified.set((Object)Boolean.TRUE);
            }
            return true;
        });
        if (!anythingModified.isNull()) {
            PropertyInspector inspector;
            this.refresh();
            DesignerToolWindow designerToolWindow = DesignerToolWindowManager.getInstance(this);
            ComponentTree tree = designerToolWindow.getComponentTree();
            if (tree != null) {
                tree.repaint();
            }
            if ((inspector = designerToolWindow.getPropertyInspector()) != null) {
                inspector.synchWithTree(true);
            }
        }
    }

    public MainProcessor getMainProcessor() {
        return this.myProcessor;
    }

    public void refreshIntentionHint() {
        this.myQuickFixManager.refreshIntentionHint();
    }

    public void setSelectionAnchor(RadComponent component) {
        this.mySelectionAnchor = new ComponentPtr(this, component);
    }

    @Nullable
    public RadComponent getSelectionAnchor() {
        if (this.mySelectionAnchor == null) {
            return null;
        }
        this.mySelectionAnchor.validate();
        return this.mySelectionAnchor.getComponent();
    }

    public void setSelectionLead(RadComponent component) {
        this.mySelectionLead = new ComponentPtr(this, component);
    }

    @Nullable
    public RadComponent getSelectionLead() {
        if (this.mySelectionLead == null) {
            return null;
        }
        this.mySelectionLead.validate();
        return this.mySelectionLead.getComponent();
    }

    public void scrollComponentInView(RadComponent component) {
        Rectangle rect = SwingUtilities.convertRectangle(component.getDelegee().getParent(), component.getBounds(), (Component)((Object)this.myLayeredPane));
        this.myLayeredPane.scrollRectToVisible(rect);
    }

    public static ReplaceInfo findFragmentToChange(String oldText, String newText) {
        char c2;
        char c1;
        int idxInNew;
        int endOffset;
        int startOffset;
        if (oldText.equals(newText)) {
            return new ReplaceInfo(-1, -1, null);
        }
        int oldLength = oldText.length();
        int newLength = newText.length();
        for (startOffset = 0; startOffset < oldLength && startOffset < newLength && oldText.charAt(startOffset) == newText.charAt(startOffset); ++startOffset) {
        }
        for (endOffset = oldLength; endOffset > startOffset && (idxInNew = newLength - (oldLength - endOffset) - 1) >= startOffset && (c1 = oldText.charAt(endOffset - 1)) == (c2 = newText.charAt(idxInNew)); --endOffset) {
        }
        return new ReplaceInfo(startOffset, endOffset, newText.substring(startOffset, newLength - (oldLength - endOffset)));
    }

    private void setRootContainer(@NotNull RadRootContainer rootContainer) {
        if (rootContainer == null) {
            GuiEditor.$$$reportNull$$$0(15);
        }
        if (this.myRootContainer != null) {
            this.myLayeredPane.remove(this.myRootContainer.getDelegee());
        }
        this.myRootContainer = rootContainer;
        this.setDesignTimeInsets(2);
        this.myLayeredPane.add(this.myRootContainer.getDelegee(), LAYER_COMPONENT);
        this.fireHierarchyChanged();
    }

    public void setDesignTimeInsets(int insets) {
        Integer oldInsets = (Integer)this.myRootContainer.getDelegee().getClientProperty(GridLayoutManager.DESIGN_TIME_INSETS);
        if (oldInsets == null || oldInsets != insets) {
            this.myRootContainer.getDelegee().putClientProperty(GridLayoutManager.DESIGN_TIME_INSETS, insets);
            GuiEditor.revalidateRecursive(this.myRootContainer.getDelegee());
        }
    }

    private static void revalidateRecursive(JComponent component) {
        for (Component child : component.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            GuiEditor.revalidateRecursive((JComponent)child);
        }
        component.revalidate();
        component.repaint();
    }

    public void readFromFile(boolean keepSelection) {
        try {
            ComponentPtr[] selection = null;
            Map<String, String> tabbedPaneSelectedTabs = null;
            if (keepSelection) {
                selection = SelectionState.getSelection(this);
                tabbedPaneSelectedTabs = this.saveTabbedPaneSelectedTabs();
            }
            Locale oldLocale = null;
            if (this.myRootContainer != null) {
                oldLocale = this.myRootContainer.getStringDescriptorLocale();
            }
            String text = this.myDocument.getText();
            ClassLoader classLoader = LoaderFactory.getInstance(this.getProject()).getLoader(this.myFile);
            LwRootContainer rootContainer = Utils.getRootContainer((String)text, (PropertiesProvider)new CompiledClassPropertiesProvider(classLoader));
            RadRootContainer container = XmlReader.createRoot(this, rootContainer, classLoader, oldLocale);
            this.setRootContainer(container);
            if (keepSelection) {
                SelectionState.restoreSelection(this, selection);
                this.restoreTabbedPaneSelectedTabs(tabbedPaneSelectedTabs);
            }
            this.myInvalid = false;
            this.myCardLayout.show(this.myCardPanel, CARD_VALID);
            this.refresh();
        }
        catch (Exception exc) {
            Throwable original = exc;
            while (original instanceof InvocationTargetException) {
                original = original.getCause();
            }
            this.showInvalidCard(original);
        }
        catch (LinkageError exc) {
            this.showInvalidCard(exc);
        }
    }

    private void showInvalidCard(Throwable exc) {
        LOG.info(exc);
        this.setRootContainer(new RadRootContainer(this, "0"));
        this.myFormInvalidLabel.setText(UIDesignerBundle.message("error.form.file.is.invalid.message", FormEditingUtil.getExceptionMessage(exc)));
        this.myInvalid = true;
        this.myCardLayout.show(this.myCardPanel, CARD_INVALID);
        this.repaint();
    }

    public boolean isFormInvalid() {
        return this.myInvalid;
    }

    private Map<String, String> saveTabbedPaneSelectedTabs() {
        HashMap<String, String> result = new HashMap<String, String>();
        FormEditingUtil.iterate(this.getRootContainer(), component -> {
            RadTabbedPane tabbedPane;
            RadComponent c;
            if (component instanceof RadTabbedPane && (c = (tabbedPane = (RadTabbedPane)component).getSelectedTab()) != null) {
                result.put(tabbedPane.getId(), c.getId());
            }
            return true;
        });
        return result;
    }

    private void restoreTabbedPaneSelectedTabs(Map<String, String> tabbedPaneSelectedTabs) {
        FormEditingUtil.iterate(this.getRootContainer(), component -> {
            RadTabbedPane tabbedPane;
            String selectedTabId;
            if (component instanceof RadTabbedPane && (selectedTabId = (String)tabbedPaneSelectedTabs.get((tabbedPane = (RadTabbedPane)component).getId())) != null) {
                for (RadComponent c : tabbedPane.getComponents()) {
                    if (!c.getId().equals(selectedTabId)) continue;
                    tabbedPane.selectTab(c);
                    break;
                }
            }
            return true;
        });
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myValidCard.isVisible()) {
            return this.myGlassLayer;
        }
        return this.myInvalidCard;
    }

    public static void repaintLayeredPane(RadComponent component) {
        GuiEditor uiEditor = (GuiEditor)SwingUtilities.getAncestorOfClass(GuiEditor.class, component.getDelegee());
        if (uiEditor != null) {
            uiEditor.repaintLayeredPane();
        }
    }

    public boolean isShowGrid() {
        return this.myShowGrid;
    }

    public void setShowGrid(boolean showGrid) {
        if (this.myShowGrid != showGrid) {
            this.myShowGrid = showGrid;
            this.repaint();
        }
    }

    public boolean isShowComponentTags() {
        return this.myShowComponentTags;
    }

    public void setShowComponentTags(boolean showComponentTags) {
        if (this.myShowComponentTags != showComponentTags) {
            this.myShowComponentTags = showComponentTags;
            this.repaint();
        }
    }

    public DesignDropTargetListener getDropTargetListener() {
        return this.myDropTargetListener;
    }

    @Nullable
    public GridCaptionPanel getFocusedCaptionPanel() {
        if (this.myHorzCaptionPanel.isFocusOwner()) {
            return this.myHorzCaptionPanel;
        }
        if (this.myVertCaptionPanel.isFocusOwner()) {
            return this.myVertCaptionPanel;
        }
        return null;
    }

    public boolean isUndoRedoInProgress() {
        UndoManager undoManager = UndoManager.getInstance((Project)this.getProject());
        return undoManager.isUndoInProgress() || undoManager.isRedoInProgress();
    }

    void hideIntentionHint() {
        this.myQuickFixManager.hideIntentionHint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showFormSource() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Editor editor = editorFactory.createViewer(this.myDocument, this.myProject);
        try {
            ((EditorEx)editor).setHighlighter((EditorHighlighter)new LexerEditorHighlighter((SyntaxHighlighter)new XmlFileHighlighter(), EditorColorsManager.getInstance().getGlobalScheme()));
            JComponent component = editor.getComponent();
            component.setPreferredSize(new Dimension(640, 480));
            DialogBuilder dialog = new DialogBuilder(this.myProject);
            dialog.title("Form - " + this.myFile.getPresentableName()).dimensionKey("GuiDesigner.FormSource.Dialog");
            dialog.centerPanel(component).setPreferredFocusComponent(editor.getContentComponent());
            dialog.addOkAction();
            dialog.show();
        }
        finally {
            editorFactory.releaseEditor(editor);
        }
    }

    public void paletteKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 16 && PaletteToolWindowManager.getInstance(this).getActiveItem(ComponentItem.class) != null) {
            this.setDesignTimeInsets(12);
        }
    }

    public void paletteKeyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.setDesignTimeInsets(2);
        }
    }

    public void paletteDropActionChanged(int gestureModifiers) {
        if ((gestureModifiers & 1) != 0) {
            this.setDesignTimeInsets(12);
        } else {
            this.setDesignTimeInsets(2);
        }
    }

    public void paletteValueChanged(ListSelectionEvent e) {
        if (PaletteToolWindowManager.getInstance(this).getActiveItem() == null) {
            this.myProcessor.cancelPaletteInsert();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/designSurface/GuiEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/designSurface/GuiEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootContainer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlassLayer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayeredPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addHierarchyChangeListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeHierarchyChangeListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setRootContainer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRefreshPropertiesRequest
    implements Runnable {
        private MyRefreshPropertiesRequest() {
        }

        @Override
        public void run() {
            if (!(GuiEditor.this.getModule().isDisposed() || GuiEditor.this.getProject().isDisposed() || DumbService.isDumb((Project)GuiEditor.this.getProject()))) {
                GuiEditor.this.refreshProperties();
            }
        }
    }

    private class MySynchronizeRequest
    implements Runnable {
        private final boolean myKeepSelection;

        MySynchronizeRequest(boolean keepSelection) {
            this.myKeepSelection = keepSelection;
        }

        @Override
        public void run() {
            if (GuiEditor.this.getModule().isDisposed()) {
                return;
            }
            Project project = GuiEditor.this.getProject();
            if (project.isDisposed()) {
                return;
            }
            LOG.debug("Synchronizing GUI editor " + GuiEditor.this.myFile.getName() + " to document");
            PsiDocumentManager.getInstance((Project)project).commitDocument(GuiEditor.this.myDocument);
            GuiEditor.this.readFromFile(this.myKeepSelection);
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private final Alarm myAlarm;
        private final MyRefreshPropertiesRequest myRefreshPropertiesRequest;
        private final MySynchronizeRequest mySynchronizeRequest;

        MyPsiTreeChangeListener() {
            this.myRefreshPropertiesRequest = new MyRefreshPropertiesRequest();
            this.mySynchronizeRequest = new MySynchronizeRequest(true);
            this.myAlarm = new Alarm();
        }

        public void dispose() {
            this.myAlarm.cancelAllRequests();
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(0);
            }
            this.handleEvent(event);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(1);
            }
            this.handleEvent(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(2);
            }
            this.handleEvent(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(3);
            }
            this.handleEvent(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(4);
            }
            this.handleEvent(event);
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(5);
            }
            if ("roots".equals(event.getPropertyName())) {
                this.myAlarm.cancelRequest((Runnable)this.myRefreshPropertiesRequest);
                this.myAlarm.addRequest((Runnable)this.myRefreshPropertiesRequest, 500, ModalityState.stateForComponent((Component)GuiEditor.this));
            }
        }

        private void handleEvent(PsiTreeChangeEvent event) {
            if (event.getParent() != null) {
                PsiFile containingFile = event.getParent().getContainingFile();
                if (containingFile instanceof PropertiesFile) {
                    LOG.debug("Received PSI change event for properties file");
                    this.myAlarm.cancelRequest((Runnable)this.myRefreshPropertiesRequest);
                    this.myAlarm.addRequest((Runnable)this.myRefreshPropertiesRequest, 500, ModalityState.stateForComponent((Component)GuiEditor.this));
                } else if (containingFile instanceof PsiPlainTextFile && containingFile.getFileType().equals(StdFileTypes.GUI_DESIGNER_FORM)) {
                    String resourceName = FormEditingUtil.buildResourceName(containingFile);
                    if (GuiEditor.this.myDocument.getText().contains(resourceName)) {
                        LOG.debug("Received PSI change event for nested form");
                        this.myAlarm.cancelRequest((Runnable)this.mySynchronizeRequest);
                        this.myAlarm.addRequest((Runnable)this.mySynchronizeRequest, 500, ModalityState.stateForComponent((Component)GuiEditor.this));
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/uiDesigner/designSurface/GuiEditor$MyPsiTreeChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyDeleteProvider
    implements DeleteProvider {
        private MyDeleteProvider() {
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeleteProvider.$$$reportNull$$$0(0);
            }
            if (!GuiEditor.this.ensureEditable()) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(GuiEditor.this.getProject(), () -> FormEditingUtil.deleteSelection(GuiEditor.this), UIDesignerBundle.message("command.delete.selection", new Object[0]), null);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeleteProvider.$$$reportNull$$$0(1);
            }
            return !DesignerToolWindowManager.getInstance(GuiEditor.this).getPropertyInspector().isEditing() && !GuiEditor.this.myInplaceEditingLayer.isEditing() && FormEditingUtil.canDeleteSelection(GuiEditor.this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/uiDesigner/designSurface/GuiEditor$MyDeleteProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class CancelCurrentOperationAction
    extends AnAction {
        private CancelCurrentOperationAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CancelCurrentOperationAction.$$$reportNull$$$0(0);
            }
            GuiEditor.this.myProcessor.cancelOperation();
            GuiEditor.this.myQuickFixManager.hideIntentionHint();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CancelCurrentOperationAction.$$$reportNull$$$0(1);
            }
            PropertyInspector inspector = DesignerToolWindowManager.getInstance(GuiEditor.this).getPropertyInspector();
            e.getPresentation().setEnabled(inspector != null && !inspector.isEditing());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/uiDesigner/designSurface/GuiEditor$CancelCurrentOperationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyLayeredPane
    extends JBLayeredPane
    implements Scrollable {
        private MyLayeredPane() {
        }

        public void doLayout() {
            for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                Component component = this.getComponent(i);
                component.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            int width = 0;
            int height = 0;
            for (int i = 0; i < GuiEditor.this.myRootContainer.getComponentCount(); ++i) {
                RadComponent component = GuiEditor.this.myRootContainer.getComponent(i);
                width = Math.max(width, component.getX() + component.getWidth());
                height = Math.max(height, component.getY() + component.getHeight());
            }
            Rectangle bounds = GuiEditor.this.myScrollPane.getViewport().getBounds();
            return new Dimension(Math.max(width += 50, bounds.width), Math.max(height += 40, bounds.height));
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 0) {
                return visibleRect.width - 10;
            }
            return visibleRect.height - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    public static final class ReplaceInfo {
        private final int myStartOffset;
        private final int myEndOffset;
        private final String myReplacement;

        public ReplaceInfo(int startOffset, int endOffset, String replacement) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myReplacement = replacement;
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }

        public int getEndOffset() {
            return this.myEndOffset;
        }

        public String getReplacement() {
            return this.myReplacement;
        }
    }
}

