/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector;

import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.uiDesigner.AbstractToolWindowManager;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindow;
import icons.UIDesignerIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignerToolWindowManager
extends AbstractToolWindowManager
implements Disposable {
    private final DesignerToolWindow myToolWindowPanel;

    public DesignerToolWindowManager(Project project, FileEditorManager fileEditorManager) {
        super(project, fileEditorManager);
        DesignerToolWindow designerToolWindow = this.myToolWindowPanel = ApplicationManager.getApplication().isHeadlessEnvironment() ? null : new DesignerToolWindow(project);
        if (this.myToolWindowPanel != null) {
            Disposer.register((Disposable)this, () -> this.myToolWindowPanel.dispose());
        }
    }

    public static DesignerToolWindow getInstance(GuiEditor designer) {
        DesignerToolWindowManager manager = DesignerToolWindowManager.getInstance(designer.getProject());
        if (manager.isEditorMode()) {
            return (DesignerToolWindow)manager.getContent(designer);
        }
        return manager.myToolWindowPanel;
    }

    public static DesignerToolWindowManager getInstance(Project project) {
        return (DesignerToolWindowManager)((Object)project.getComponent(DesignerToolWindowManager.class));
    }

    @Nullable
    public GuiEditor getActiveFormEditor() {
        return (GuiEditor)this.getActiveDesigner();
    }

    protected void initToolWindow() {
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(UIDesignerBundle.message("toolwindow.ui.designer.name", new Object[0]), false, this.getAnchor(), (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(UIDesignerIcons.ToolWindowUIDesigner);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myToolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        }
        this.initGearActions();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent(this.myToolWindowPanel.getToolWindowPanel(), UIDesignerBundle.message("toolwindow.ui.designer.title", new Object[0]), false);
        content.setCloseable(false);
        content.setPreferredFocusableComponent((JComponent)((Object)this.myToolWindowPanel.getComponentTree()));
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        this.myToolWindow.setAvailable(false, null);
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myToolWindowPanel.update((GuiEditor)designer);
        if (designer == null) {
            this.myToolWindow.setAvailable(false, null);
        } else {
            this.myToolWindow.setAvailable(true, null);
            this.myToolWindow.show(null);
        }
    }

    protected ToolWindowAnchor getAnchor() {
        return ToolWindowAnchor.LEFT;
    }

    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            DesignerToolWindowManager.$$$reportNull$$$0(0);
        }
        DesignerToolWindow toolWindowContent = new DesignerToolWindow(this.myProject);
        toolWindowContent.update((GuiEditor)designer);
        return this.createContent(designer, toolWindowContent, UIDesignerBundle.message("toolwindow.ui.designer.title", new Object[0]), UIDesignerIcons.ToolWindowUIDesigner, toolWindowContent.getToolWindowPanel(), (JComponent)((Object)toolWindowContent.getComponentTree()), 320, null);
    }

    @NotNull
    public String getComponentName() {
        if ("UIDesignerToolWindowManager" == null) {
            DesignerToolWindowManager.$$$reportNull$$$0(1);
        }
        return "UIDesignerToolWindowManager";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/propertyInspector/DesignerToolWindowManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/propertyInspector/DesignerToolWindowManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

