/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "()V", "canImport", "", "typeName", "", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfig", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "Companion", "intellij.junit"})
public final class JUnitRunConfigurationImporter
implements RunConfigurationImporter {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public boolean canImport(@NotNull String typeName) {
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        return Intrinsics.areEqual((Object)"junit", (Object)typeName);
    }

    public void process(@NotNull Project project, @NotNull RunConfiguration runConfig, @NotNull Map<String, ?> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        String string;
        Object v0;
        String it;
        JUnitConfiguration.Data data;
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)runConfig, (String)"runConfig");
            Intrinsics.checkParameterIsNotNull(cfg, (String)"cfg");
            Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
            if (!(runConfig instanceof JUnitConfiguration)) {
                throw (Throwable)new IllegalArgumentException("Unexpected type of run configuration: " + runConfig.getClass());
            }
            data = ((JUnitConfiguration)runConfig).getPersistentData();
            Iterable $receiver$iv = cfg.keySet();
            for (Object element$iv : $receiver$iv) {
                it = (String)element$iv;
                if (!(CollectionsKt.listOf((Object[])new String[]{"packageName", "directory", "pattern", "className", "method", "category"}).contains(it) && cfg.get(it) != null)) continue;
                v0 = element$iv;
                break block9;
            }
            v0 = null;
        }
        String testKind = v0;
        if (testKind != null) {
            ObjectUtils.consumeIfCast(cfg.get(testKind), String.class, (Consumer)new Consumer<T>(data, testKind){
                final /* synthetic */ JUnitConfiguration.Data $data;
                final /* synthetic */ String $testKind;

                /*
                 * Unable to fully structure code
                 */
                public final void consume(String testKindValue) {
                    v0 = this.$data;
                    v1 = this.$testKind;
                    if (v1 == null) ** GOTO lbl-1000
                    var2_2 = v1;
                    tmp = -1;
                    switch (var2_2.hashCode()) {
                        case -807062458: {
                            if (!var2_2.equals("package")) break;
                            tmp = 1;
                            break;
                        }
                        case -1077554975: {
                            if (!var2_2.equals("method")) break;
                            tmp = 2;
                            break;
                        }
                        case -791090288: {
                            if (!var2_2.equals("pattern")) break;
                            tmp = 3;
                            break;
                        }
                        case 50511102: {
                            if (!var2_2.equals("category")) break;
                            tmp = 4;
                            break;
                        }
                        case -962584979: {
                            if (!var2_2.equals("directory")) break;
                            tmp = 5;
                            break;
                        }
                        case 94742904: {
                            if (!var2_2.equals("class")) break;
                            tmp = 6;
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            var3_3 = "package";
                            var8_9 = v0;
                            it = var3_3;
                            this.$data.PACKAGE_NAME = testKindValue;
                            var9_21 = var3_3;
                            v0 = var8_9;
                            v2 = var9_21;
                            break;
                        }
                        case 5: {
                            var3_4 = "directory";
                            var8_10 = v0;
                            it = var3_4;
                            v3 = this.$data;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"data");
                            v3.setDirName(testKindValue);
                            var9_22 = var3_4;
                            v0 = var8_10;
                            v2 = var9_22;
                            break;
                        }
                        case 3: {
                            var3_5 = "pattern";
                            var8_11 = v0;
                            it = var3_5;
                            v4 = testKindValue;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"testKindValue");
                            this.$data.setPatterns(new LinkedHashSet<String>(StringsKt.split$default((CharSequence)v4, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null)));
                            var9_23 = var3_5;
                            v0 = var8_11;
                            v2 = var9_23;
                            break;
                        }
                        case 6: {
                            var3_6 = "class";
                            var8_12 = v0;
                            it = var3_6;
                            this.$data.MAIN_CLASS_NAME = testKindValue;
                            var9_24 = var3_6;
                            v0 = var8_12;
                            v2 = var9_24;
                            break;
                        }
                        case 2: {
                            var3_7 = "method";
                            var8_13 = v0;
                            it = var3_7;
                            v5 = testKindValue;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"testKindValue");
                            className = StringsKt.substringBefore$default((String)v5, (char)'#', null, (int)2, null);
                            methodName = StringsKt.substringAfter$default((String)testKindValue, (char)'#', null, (int)2, null);
                            this.$data.MAIN_CLASS_NAME = className;
                            this.$data.METHOD_NAME = methodName;
                            var9_25 = var3_7;
                            v0 = var8_13;
                            v2 = var9_25;
                            break;
                        }
                        case 4: {
                            var3_8 = "category";
                            var8_14 = v0;
                            it = var3_8;
                            this.$data.setCategoryName(testKindValue);
                            var9_26 = var3_8;
                            v0 = var8_14;
                            v2 = var9_26;
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            v2 = this.$data.TEST_OBJECT;
                        }
                    }
                    v0.TEST_OBJECT = v2;
                }
                {
                    this.$data = data;
                    this.$testKind = string;
                }
            });
        }
        Object repeatValue = cfg.get("repeat");
        JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)runConfig;
        Iterator<Object> iterator = repeatValue;
        if (Intrinsics.areEqual(iterator, (Object)"untilStop")) {
            string = "Until Stopped";
        } else if (Intrinsics.areEqual(iterator, (Object)"untilFailure")) {
            string = "Until Failure";
        } else if (iterator instanceof Number) {
            String string2 = "N Times";
            JUnitConfiguration jUnitConfiguration2 = jUnitConfiguration;
            it = string2;
            ((JUnitConfiguration)runConfig).setRepeatCount(((Number)repeatValue).intValue());
            String string3 = string2;
            jUnitConfiguration = jUnitConfiguration2;
            string = string3;
        } else {
            string = ((JUnitConfiguration)runConfig).getRepeatMode();
        }
        jUnitConfiguration.setRepeatMode(string);
        ObjectUtils.consumeIfCast(cfg.get("vmParameters"), String.class, (Consumer)new Consumer<T>(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;

            public final void consume(String it) {
                ((JUnitConfiguration)this.$runConfig).setVMParameters(it);
            }
            {
                this.$runConfig = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("workingDirectory"), String.class, (Consumer)new Consumer<T>(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;

            public final void consume(String it) {
                ((JUnitConfiguration)this.$runConfig).setWorkingDirectory(it);
            }
            {
                this.$runConfig = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("passParentEnvs"), Boolean.TYPE, (Consumer)new Consumer<T>(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;

            public final void consume(Boolean it) {
                JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)this.$runConfig;
                Boolean bl = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"it");
                jUnitConfiguration.setPassParentEnvs(bl);
            }
            {
                this.$runConfig = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("envs"), Map.class, (Consumer)new Consumer<T>(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;

            public final void consume(Map<?, ?> it) {
                Map<String, String> map = it;
                if (map == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                }
                ((JUnitConfiguration)this.$runConfig).setEnvs(map);
            }
            {
                this.$runConfig = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("moduleName"), String.class, (Consumer)new Consumer<T>(modelsProvider, runConfig){
            final /* synthetic */ IdeModifiableModelsProvider $modelsProvider;
            final /* synthetic */ RunConfiguration $runConfig;

            public final void consume(String it) {
                Module module = this.$modelsProvider.getModifiableModuleModel().findModuleByName(it);
                if (module != null) {
                    ((JUnitConfiguration)this.$runConfig).setModule(module);
                }
            }
            {
                this.$modelsProvider = ideModifiableModelsProvider;
                this.$runConfig = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("shortenCommandLine"), String.class, (Consumer)new Consumer<T>(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;

            public final void consume(String it) {
                try {
                    JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)this.$runConfig;
                    String string = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    jUnitConfiguration.setShortenCommandLine(ShortenCommandLine.valueOf((String)string));
                }
                catch (IllegalArgumentException e) {
                    JUnitRunConfigurationImporter.Companion.getLOG().warn("Illegal value of 'shortenCommandLine': " + it, (Throwable)e);
                }
            }
            {
                this.$runConfig = runConfiguration;
            }
        });
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = ((JUnitConfigurationType)ConfigurationTypeUtil.findConfigurationType(JUnitConfigurationType.class)).getConfigurationFactories()[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory, (String)"ConfigurationTypeUtil\n  \u2026configurationFactories[0]");
        return configurationFactory;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(JUnitRunConfigurationImporter.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(JUnit\u2026tionImporter::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.junit"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

