/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.VisitorCallback;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.GrUnresolvedAccessChecker;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class ResolveHighlightingVisitor
extends GroovyRecursiveElementVisitor {
    private final GrUnresolvedAccessChecker myReferenceChecker;
    private final VisitorCallback myCallback;
    private int myTriggerCounter;

    public ResolveHighlightingVisitor(@NotNull GroovyFileBase file, @NotNull Project project, @NotNull VisitorCallback callback) {
        if (file == null) {
            ResolveHighlightingVisitor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ResolveHighlightingVisitor.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            ResolveHighlightingVisitor.$$$reportNull$$$0(2);
        }
        this.myTriggerCounter = 0;
        this.myCallback = callback;
        this.myReferenceChecker = new GrUnresolvedAccessChecker(file, project);
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            ResolveHighlightingVisitor.$$$reportNull$$$0(3);
        }
        int oldValue = this.myTriggerCounter;
        super.visitReferenceExpression(referenceExpression);
        if (oldValue != this.myTriggerCounter) {
            return;
        }
        List<HighlightInfo> infos = this.myReferenceChecker.checkReferenceExpression(referenceExpression);
        if (infos == null) {
            return;
        }
        infos.forEach(info -> {
            if (referenceExpression == null) {
                ResolveHighlightingVisitor.$$$reportNull$$$0(5);
            }
            this.myCallback.trigger(referenceExpression, (HighlightInfo)info);
            ++this.myTriggerCounter;
        });
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        if (refElement == null) {
            ResolveHighlightingVisitor.$$$reportNull$$$0(4);
        }
        int oldValue = this.myTriggerCounter;
        super.visitCodeReferenceElement(refElement);
        if (oldValue != this.myTriggerCounter) {
            return;
        }
        HighlightInfo info = this.myReferenceChecker.checkCodeReferenceElement(refElement);
        if (info != null) {
            this.myCallback.trigger(refElement, info);
            ++this.myTriggerCounter;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/ResolveHighlightingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCodeReferenceElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$visitReferenceExpression$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

