/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageHelper;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;

public class CreateFieldFix {
    private final PsiClass myTargetClass;

    protected CreateFieldFix(PsiClass targetClass) {
        this.myTargetClass = targetClass;
    }

    protected void doFix(@NotNull Project project, @NotNull @PsiModifier.ModifierConstant String[] modifiers, @NotNull @NonNls String fieldName, @NotNull TypeConstraint[] typeConstraints, @NotNull PsiElement context) throws IncorrectOperationException {
        JVMElementFactory factory;
        if (project == null) {
            CreateFieldFix.$$$reportNull$$$0(0);
        }
        if (modifiers == null) {
            CreateFieldFix.$$$reportNull$$$0(1);
        }
        if (fieldName == null) {
            CreateFieldFix.$$$reportNull$$$0(2);
        }
        if (typeConstraints == null) {
            CreateFieldFix.$$$reportNull$$$0(3);
        }
        if (context == null) {
            CreateFieldFix.$$$reportNull$$$0(4);
        }
        if ((factory = JVMElementFactories.getFactory((Language)this.myTargetClass.getLanguage(), (Project)project)) == null) {
            return;
        }
        PsiField field = factory.createField(fieldName, (PsiType)PsiType.INT);
        if (this.myTargetClass instanceof GroovyScriptClass) {
            field.getModifierList().addAnnotation("groovy.transform.Field");
        }
        for (String modifier : modifiers) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)modifier, (boolean)true);
        }
        field = CreateFieldFromUsageHelper.insertField((PsiClass)this.myTargetClass, (PsiField)field, (PsiElement)context);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(field.getParent());
        Editor newEditor = IntentionUtils.positionCursor(project, this.myTargetClass.getContainingFile(), (PsiElement)field);
        Template template = CreateFieldFromUsageHelper.setupTemplate((PsiField)field, (Object)typeConstraints, (PsiClass)this.myTargetClass, (Editor)newEditor, (PsiElement)context, (boolean)false);
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        manager.startTemplate(newEditor, template);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "modifiers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "fieldName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "typeConstraints";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFix";
        objectArray[2] = "doFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

