/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.console.ConsoleRootType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.console.GroovyConsoleStateService;
import org.jetbrains.plugins.groovy.console.actions.GrExecuteCommandAction;

public final class GroovyConsoleRootType
extends ConsoleRootType {
    public static final AnAction EXECUTE_ACTION = new GrExecuteCommandAction();
    public static final String CONTENT_ID = "groovy_console";

    @NotNull
    public static GroovyConsoleRootType getInstance() {
        GroovyConsoleRootType groovyConsoleRootType = (GroovyConsoleRootType)GroovyConsoleRootType.findByClass(GroovyConsoleRootType.class);
        if (groovyConsoleRootType == null) {
            GroovyConsoleRootType.$$$reportNull$$$0(0);
        }
        return groovyConsoleRootType;
    }

    public GroovyConsoleRootType() {
        super("groovy", "Groovy consoles");
    }

    @NotNull
    public String getDefaultFileExtension() {
        if ("groovy" == null) {
            GroovyConsoleRootType.$$$reportNull$$$0(1);
        }
        return "groovy";
    }

    public boolean isIgnored(@NotNull Project project, @NotNull VirtualFile element) {
        if (project == null) {
            GroovyConsoleRootType.$$$reportNull$$$0(2);
        }
        if (element == null) {
            GroovyConsoleRootType.$$$reportNull$$$0(3);
        }
        return !GroovyConsoleStateService.getInstance(project).isProjectConsole(element);
    }

    @NotNull
    public String getContentPathName(@NotNull String id) {
        if (id == null) {
            GroovyConsoleRootType.$$$reportNull$$$0(4);
        }
        assert (id == CONTENT_ID);
        if (CONTENT_ID == null) {
            GroovyConsoleRootType.$$$reportNull$$$0(5);
        }
        return CONTENT_ID;
    }

    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            GroovyConsoleRootType.$$$reportNull$$$0(6);
        }
        if (file == null) {
            GroovyConsoleRootType.$$$reportNull$$$0(7);
        }
        if (!Registry.is((String)"groovy.console.project.view.names")) {
            return null;
        }
        String name = file.getName();
        String moduleTitle = GroovyConsoleStateService.getInstance(project).getSelectedModuleTitle(file);
        return name.startsWith(CONTENT_ID) ? StringUtil.replace((String)name, (String)CONTENT_ID, (String)(moduleTitle == null ? "unknown" : moduleTitle)) : String.format("%s-%s", moduleTitle, name);
    }

    public void fileOpened(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            GroovyConsoleRootType.$$$reportNull$$$0(8);
        }
        if (source == null) {
            GroovyConsoleRootType.$$$reportNull$$$0(9);
        }
        for (FileEditor fileEditor : source.getAllEditors(file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            EXECUTE_ACTION.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, fileEditor.getComponent());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/console/GroovyConsoleRootType";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileExtension";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/console/GroovyConsoleRootType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPathName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContentPathName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substituteName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

