/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.bundled.BundledGroovy;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtilKt;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

public class GroovyConsoleUtil {
    @NotNull
    public static String getDisplayGroovyVersion(@NotNull Module module) {
        String moduleGroovyHomePath;
        if (module == null) {
            GroovyConsoleUtil.$$$reportNull$$$0(0);
        }
        boolean bundled = (moduleGroovyHomePath = LibrariesUtil.getGroovyHomePath(module)) == null || !GroovyConsoleUtil.hasGroovyAll(module);
        String version = bundled ? BundledGroovy.getBundledGroovyVersion() : GroovyConfigUtils.getInstance().getSDKVersion(moduleGroovyHomePath);
        StringBuilder result2 = new StringBuilder();
        if (bundled) {
            result2.append("Bundled ");
        }
        result2.append("Groovy");
        if (version != "undefined") {
            result2.append(" ").append(version);
        }
        String string = result2.toString();
        if (string == null) {
            GroovyConsoleUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    static boolean hasGroovyAll(Module module) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        return (facade.findClass("org.apache.commons.cli.CommandLineParser", scope) != null || facade.findClass("groovyjarjarcommonscli.CommandLineParser", scope) != null) && facade.findClass("groovy.ui.GroovyMain", scope) != null;
    }

    public static void selectModuleAndRun(Project project, Consumer<Module> consumer) {
        ModuleChooserUtil.selectModule(project, GroovyConsoleUtilKt.getApplicableModules(project), (Function<Module, String>)((Function)GroovyConsoleUtil::getDisplayGroovyVersion), consumer);
    }

    @NotNull
    public static String getTitle(@NotNull Module module) {
        if (module == null) {
            GroovyConsoleUtil.$$$reportNull$$$0(2);
        }
        String string = ModuleChooserUtil.formatModuleVersion(module, GroovyConsoleUtil.getDisplayGroovyVersion(module));
        if (string == null) {
            GroovyConsoleUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/console/GroovyConsoleUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/console/GroovyConsoleUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayGroovyVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayGroovyVersion";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

