/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;

public class GroovyGStringSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        PsiElement parent;
        if (e == null) {
            GroovyGStringSelectioner.$$$reportNull$$$0(0);
        }
        return (parent = e.getParent()) instanceof GrStringInjection || parent instanceof GrString || parent instanceof GrStringContent;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (e == null) {
            GroovyGStringSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            GroovyGStringSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GroovyGStringSelectioner.$$$reportNull$$$0(3);
        }
        ArrayList ranges = ContainerUtil.newArrayList();
        PsiElement parent = e.getParent();
        if (parent instanceof GrStringContent && parent.getParent() instanceof GrString) {
            TextRange range = GroovyGStringSelectioner.getLineTextRange(parent, cursorOffset);
            ranges.add(range);
        } else if (parent instanceof GrString) {
            PsiElement firstChild = parent.getFirstChild();
            PsiElement lastChild = parent.getLastChild();
            if (firstChild.getNode().getElementType() == GroovyTokenTypes.mGSTRING_BEGIN) {
                firstChild = firstChild.getNextSibling();
            }
            if (lastChild.getNode().getElementType() == GroovyTokenTypes.mGSTRING_END) {
                lastChild = lastChild.getPrevSibling();
            }
            if (firstChild != null && lastChild != null) {
                TextRange range = new TextRange(firstChild.getTextOffset(), lastChild.getTextOffset() + lastChild.getTextLength());
                ranges.add(range);
            }
            ranges.add(parent.getTextRange());
        } else if (parent instanceof GrStringInjection) {
            if (e instanceof GrReferenceExpression) {
                ArrayList r = new ArrayList(2);
                SelectWordUtil.addWordSelection((boolean)editor.getSettings().isCamelWords(), (CharSequence)editorText, (int)cursorOffset, r);
                for (TextRange textRange : r) {
                    if (editorText.charAt(textRange.getStartOffset()) == '$') {
                        textRange = new TextRange(textRange.getStartOffset() + 1, textRange.getEndOffset());
                    }
                    ranges.add(textRange);
                }
            }
            ranges.add(parent.getTextRange());
            ranges.add(e.getTextRange());
        }
        return ranges;
    }

    @NotNull
    private static TextRange getLineTextRange(PsiElement e, int cursorOffset) {
        ASTNode node;
        assert (e.getParent() instanceof GrString);
        PsiElement next = e;
        int startOffset = cursorOffset;
        int endOffset = cursorOffset;
        if (e.getNode().getElementType() == GroovyTokenTypes.mGSTRING_CONTENT) {
            int cur;
            String text = e.getText();
            int index = -1;
            while ((cur = text.indexOf(10, index + 1)) >= 0 && cur + e.getTextOffset() <= cursorOffset) {
                index = cur;
            }
            if (index >= 0) {
                startOffset = e.getTextOffset() + index + 1;
            }
            if ((index = text.indexOf(10, cursorOffset - e.getTextOffset())) >= 0) {
                endOffset = e.getTextOffset() + index + 1;
            }
        }
        if (startOffset == cursorOffset) {
            while (next != null && (node = next.getNode()) != null) {
                String text;
                int i;
                IElementType type = node.getElementType();
                if (type == GroovyTokenTypes.mGSTRING_BEGIN) {
                    startOffset = next.getTextRange().getEndOffset();
                    break;
                }
                if (type == GroovyElementTypes.GSTRING_CONTENT && (i = (text = startOffset == cursorOffset && next.getTextRange().contains(cursorOffset) ? next.getText().substring(0, startOffset - next.getTextOffset()) : next.getText()).lastIndexOf(10)) >= 0) {
                    startOffset = next.getTextOffset() + i + 1;
                    break;
                }
                startOffset = next.getTextOffset();
                next = next.getPrevSibling();
            }
        }
        if (endOffset == cursorOffset) {
            for (next = e; next != null && (node = next.getNode()) != null; next = next.getNextSibling()) {
                IElementType type = node.getElementType();
                if (type == GroovyTokenTypes.mGSTRING_END) {
                    endOffset = next.getTextOffset();
                    break;
                }
                if (type == GroovyElementTypes.GSTRING_CONTENT) {
                    String text;
                    int offset;
                    if (endOffset == cursorOffset && next.getTextRange().contains(cursorOffset)) {
                        offset = endOffset - next.getTextOffset();
                        text = next.getText().substring(offset);
                    } else {
                        offset = 0;
                        text = next.getText();
                    }
                    int i = text.indexOf(10);
                    if (i >= 0) {
                        endOffset = next.getTextOffset() + offset + i;
                        break;
                    }
                }
                endOffset = next.getTextOffset() + next.getTextLength();
            }
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            GroovyGStringSelectioner.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/editor/selection/GroovyGStringSelectioner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/editor/selection/GroovyGStringSelectioner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

