/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.search.GrSourceFilterScope;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class MethodLateBoundReferencesSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public MethodLateBoundReferencesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        if (queryParameters == null) {
            MethodLateBoundReferencesSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            MethodLateBoundReferencesSearcher.$$$reportNull$$$0(1);
        }
        PsiMethod method = queryParameters.getMethod();
        SearchScope searchScope = GroovyScopeUtil.restrictScopeToGroovyFiles(queryParameters.getEffectiveSearchScope()).intersectWith(MethodLateBoundReferencesSearcher.getUseScope(method));
        MethodLateBoundReferencesSearcher.orderSearching(searchScope, method.getName(), method, queryParameters.getOptimizer(), method.getParameterList().getParametersCount());
        String propName = PropertyUtilBase.getPropertyName((PsiMethod)method);
        if (propName != null) {
            MethodLateBoundReferencesSearcher.orderSearching(searchScope, propName, method, queryParameters.getOptimizer(), -1);
        }
    }

    private static SearchScope getUseScope(PsiMethod method) {
        SearchScope scope = method.getUseScope();
        PsiFile file = method.getContainingFile();
        if (file != null && scope instanceof GlobalSearchScope) {
            VirtualFile vfile = file.getOriginalFile().getVirtualFile();
            Project project = method.getProject();
            if (vfile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInSource(vfile)) {
                return new GrSourceFilterScope((GlobalSearchScope)scope);
            }
        }
        return scope;
    }

    private static void orderSearching(SearchScope searchScope, final String name, @NotNull PsiMethod searchTarget, @NotNull SearchRequestCollector collector, final int paramCount) {
        if (searchTarget == null) {
            MethodLateBoundReferencesSearcher.$$$reportNull$$$0(2);
        }
        if (collector == null) {
            MethodLateBoundReferencesSearcher.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        collector.searchWord(name, searchScope, (short)1, true, (PsiElement)searchTarget, new RequestResultProcessor(new Object[]{"groovy.lateBound"}){

            public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (consumer == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof GrReferenceExpression)) {
                    return true;
                }
                GrReferenceExpression ref = (GrReferenceExpression)element;
                if (!name.equals(ref.getReferenceName()) || PsiUtil.isLValue(ref)) {
                    return true;
                }
                PsiElement parent = ref.getParent();
                if (parent instanceof GrCommandArgumentList) {
                    parent = parent.getParent();
                }
                if (!(paramCount < 0 || ref.hasMemberPointer() || parent instanceof GrMethodCall && MethodLateBoundReferencesSearcher.argumentsMatch((GrMethodCall)parent, paramCount))) {
                    return true;
                }
                GrExpression qualifier = ref.getQualifierExpression();
                if (qualifier == null || qualifier.getType() != null) {
                    return true;
                }
                if (ref.resolve() != null) {
                    return true;
                }
                if (ResolveUtil.isKeyOfMap(ref)) {
                    return true;
                }
                return consumer.process((Object)((PsiReference)element));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "consumer";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/findUsages/MethodLateBoundReferencesSearcher$1";
                objectArray[2] = "processTextOccurrence";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean argumentsMatch(GrMethodCall call, int paramCount) {
        int argCount = call.getExpressionArguments().length + call.getClosureArguments().length;
        if (PsiImplUtil.hasNamedArguments(call.getArgumentList())) {
            ++argCount;
        }
        return argCount == paramCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/findUsages/MethodLateBoundReferencesSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "orderSearching";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

