/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

class ConvertibleGStringLiteralPredicate
implements PsiElementPredicate {
    ConvertibleGStringLiteralPredicate() {
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            ConvertibleGStringLiteralPredicate.$$$reportNull$$$0(0);
        }
        if (!(element instanceof GrLiteral)) {
            return false;
        }
        if (ErrorUtil.containsError(element)) {
            return false;
        }
        String text = element.getText();
        if (text.charAt(0) != '\"') {
            return false;
        }
        for (PsiElement child : element.getChildren()) {
            GrClosableBlock block;
            if (!(child instanceof GrStringInjection) || (block = ((GrStringInjection)child).getClosableBlock()) == null || ConvertibleGStringLiteralPredicate.checkClosure(block)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkClosure(GrClosableBlock block) {
        if (block.hasParametersSection()) {
            return false;
        }
        GrStatement[] statements = block.getStatements();
        if (statements.length != 1) {
            return false;
        }
        return statements[0] instanceof GrExpression || statements[0] instanceof GrReturnStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertibleGStringLiteralPredicate", "satisfiedBy"));
    }
}

