/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaNoVariantsDelegator;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.GrMainCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovySmartCompletionContributor;
import org.jetbrains.plugins.groovy.lang.completion.MapArgumentCompletionProvider;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyNoVariantsDelegator
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.completion.GroovyNoVariantsDelegator");

    private static boolean suggestAnnotations(CompletionParameters parameters) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{GrCodeReferenceElement.class, GrAnnotation.class})).accepts((Object)parameters.getPosition());
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        boolean empty;
        if (parameters == null) {
            GroovyNoVariantsDelegator.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            GroovyNoVariantsDelegator.$$$reportNull$$$0(1);
        }
        JavaNoVariantsDelegator.ResultTracker tracker = new JavaNoVariantsDelegator.ResultTracker(result2);
        result2.runRemainingContributors(parameters, (Consumer)tracker);
        boolean bl = empty = tracker.containsOnlyPackages || GroovyNoVariantsDelegator.suggestAnnotations(parameters);
        if (GrMainCompletionProvider.isClassNamePossible(parameters.getPosition()) && !JavaCompletionContributor.mayStartClassName((CompletionResultSet)result2)) {
            result2.restartCompletionOnAnyPrefixChange();
        }
        if (empty) {
            GroovyNoVariantsDelegator.delegate(parameters, result2);
        } else if (Registry.is((String)"ide.completion.show.better.matching.classes") && parameters.getCompletionType() == CompletionType.BASIC && parameters.getInvocationCount() <= 1 && JavaCompletionContributor.mayStartClassName((CompletionResultSet)result2) && GrMainCompletionProvider.isClassNamePossible(parameters.getPosition()) && !MapArgumentCompletionProvider.isMapKeyCompletion(parameters) && !GroovyNoVariantsDelegator.areNonImportedInheritorsAlreadySuggested(parameters)) {
            result2 = result2.withPrefixMatcher((PrefixMatcher)tracker.betterMatcher);
            GroovyNoVariantsDelegator.suggestNonImportedClasses(parameters, result2);
        }
    }

    private static boolean areNonImportedInheritorsAlreadySuggested(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            GroovyNoVariantsDelegator.$$$reportNull$$$0(2);
        }
        return GroovySmartCompletionContributor.AFTER_NEW.accepts((Object)parameters.getPosition()) && GroovySmartCompletionContributor.getExpectedTypes(parameters).length > 0;
    }

    private static void delegate(CompletionParameters parameters, CompletionResultSet result2) {
        if (parameters.getCompletionType() == CompletionType.BASIC) {
            if (parameters.getInvocationCount() <= 1 && (JavaCompletionContributor.mayStartClassName((CompletionResultSet)result2) || GroovyNoVariantsDelegator.suggestAnnotations(parameters)) && GrMainCompletionProvider.isClassNamePossible(parameters.getPosition()) && !MapArgumentCompletionProvider.isMapKeyCompletion(parameters)) {
                GroovyNoVariantsDelegator.suggestNonImportedClasses(parameters, result2);
            }
            GroovyNoVariantsDelegator.suggestChainedCalls(parameters, result2);
        }
    }

    private static void suggestNonImportedClasses(CompletionParameters parameters, CompletionResultSet result2) {
        GrMainCompletionProvider.addAllClasses(parameters, (Consumer<? super LookupElement>)((Consumer)element -> {
            JavaPsiClassReferenceElement classElement = (JavaPsiClassReferenceElement)element.as(JavaPsiClassReferenceElement.CLASS_CONDITION_KEY);
            if (classElement != null) {
                classElement.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
            }
            result2.addElement(element);
        }), new JavaCompletionSession(result2), result2.getPrefixMatcher());
    }

    private static void suggestChainedCalls(CompletionParameters parameters, CompletionResultSet result2) {
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (!(parent instanceof GrReferenceElement)) {
            return;
        }
        PsiElement qualifier = ((GrReferenceElement)parent).getQualifier();
        if (!(qualifier instanceof GrReferenceElement) || ((GrReferenceElement)qualifier).getQualifier() != null) {
            return;
        }
        PsiElement target = ((GrReferenceElement)qualifier).resolve();
        if (target != null && !(target instanceof PsiPackage)) {
            return;
        }
        String fullPrefix = position.getContainingFile().getText().substring(parent.getTextRange().getStartOffset(), parameters.getOffset());
        CompletionResultSet qualifiedCollector = result2.withPrefixMatcher(fullPrefix);
        JavaCompletionSession session = new JavaCompletionSession(result2);
        for (LookupElement base : GroovyNoVariantsDelegator.suggestQualifierItems(parameters, (GrReferenceElement)qualifier, session)) {
            PsiElement refName;
            PsiType type = GroovyNoVariantsDelegator.getPsiType(base.getObject());
            if (type == null || PsiType.VOID.equals((Object)type)) continue;
            GrReferenceElement ref = GroovyNoVariantsDelegator.createMockReference(position, type, base);
            PsiElement psiElement = refName = ref == null ? null : ref.getReferenceNameElement();
            if (refName == null) continue;
            CompletionParameters newParams = parameters.withPosition(refName, refName.getTextRange().getStartOffset());
            GrMainCompletionProvider.completeReference(newParams, ref, session, result2.getPrefixMatcher(), (Consumer<? super LookupElement>)((Consumer)element -> qualifiedCollector.addElement((LookupElement)new JavaChainLookupElement(base, (LookupElement)element){

                protected boolean shouldParenthesizeQualifier(PsiFile file, int startOffset, int endOffset) {
                    return false;
                }
            })));
        }
    }

    @Nullable
    private static PsiType getPsiType(Object o) {
        if (o instanceof ResolveResult) {
            return GroovyNoVariantsDelegator.getPsiType(((ResolveResult)o).getElement());
        }
        if (o instanceof PsiVariable) {
            return ((PsiVariable)o).getType();
        }
        if (o instanceof PsiMethod) {
            return ((PsiMethod)o).getReturnType();
        }
        if (o instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)o;
            return JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass);
        }
        return null;
    }

    @Nullable
    private static GrReferenceElement createMockReference(PsiElement place, @NotNull PsiType qualifierType, LookupElement qualifierItem) {
        if (qualifierType == null) {
            GroovyNoVariantsDelegator.$$$reportNull$$$0(3);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(place.getProject());
        if (qualifierItem.getObject() instanceof PsiClass) {
            try {
                return factory.createReferenceExpressionFromText(((PsiClass)qualifierItem.getObject()).getQualifiedName() + ".xxx", place);
            }
            catch (IncorrectOperationException e) {
                LOG.debug((Throwable)e);
                return null;
            }
        }
        return factory.createReferenceExpressionFromText("xxx.xxx", (PsiElement)JavaCompletionUtil.createContextWithXxxVariable((PsiElement)place, (PsiType)qualifierType));
    }

    private static Set<LookupElement> suggestQualifierItems(CompletionParameters _parameters, GrReferenceElement qualifier, JavaCompletionSession session) {
        CompletionParameters parameters = _parameters.withPosition(qualifier.getReferenceNameElement(), qualifier.getTextRange().getEndOffset());
        String referenceName = qualifier.getReferenceName();
        if (referenceName == null) {
            return Collections.emptySet();
        }
        CamelHumpMatcher qMatcher = new CamelHumpMatcher(referenceName);
        LinkedHashSet<LookupElement> variants = new LinkedHashSet<LookupElement>();
        GrMainCompletionProvider.completeReference(parameters, qualifier, session, (PrefixMatcher)qMatcher, (Consumer<? super LookupElement>)((Consumer)arg_0 -> GroovyNoVariantsDelegator.lambda$suggestQualifierItems$2((PrefixMatcher)qMatcher, variants, arg_0)));
        for (PsiClass aClass : PsiShortNamesCache.getInstance((Project)qualifier.getProject()).getClassesByName(referenceName, qualifier.getResolveScope())) {
            variants.add(GroovyCompletionUtil.createClassLookupItem(aClass));
        }
        if (variants.isEmpty()) {
            GrMainCompletionProvider.addAllClasses(parameters, (Consumer<? super LookupElement>)((Consumer)arg_0 -> GroovyNoVariantsDelegator.lambda$suggestQualifierItems$3((PrefixMatcher)qMatcher, variants, arg_0)), session, (PrefixMatcher)qMatcher);
        }
        return variants;
    }

    private static /* synthetic */ void lambda$suggestQualifierItems$3(PrefixMatcher qMatcher, Set variants, LookupElement element) {
        if (qMatcher.prefixMatches(element)) {
            variants.add(element);
        }
    }

    private static /* synthetic */ void lambda$suggestQualifierItems$2(PrefixMatcher qMatcher, Set variants, LookupElement element) {
        if (qMatcher.prefixMatches(element)) {
            variants.add(element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovyNoVariantsDelegator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "areNonImportedInheritorsAlreadySuggested";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createMockReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

